> **Jupyter/VSCode/PyCharm user?** Check out my [latest project](https://github.com/ploomber/ploomber) to build modular data pipelines!

# sklearn-evaluation


![CI](https://github.com/ploomber/sklearn-evaluation/workflows/CI/badge.svg)
[![Documentation Status](https://readthedocs.org/projects/sklearn-evaluation/badge/?version=latest)](https://sklearn-evaluation.readthedocs.io/en/latest/?badge=latest)
[![PyPI version](https://badge.fury.io/py/sklearn-evaluation.svg)](https://badge.fury.io/py/sklearn-evaluation)
[![Coverage Status](https://coveralls.io/repos/github/edublancas/sklearn-evaluation/badge.svg)](https://coveralls.io/github/edublancas/sklearn-evaluation)
[![Twitter](https://img.shields.io/twitter/follow/edublancas?label=Follow&style=social)](https://twitter.com/intent/user?screen_name=ploomber)

Machine learning model evaluation made easy: plots, tables, HTML reports, experiment tracking, and Jupyter notebook analysis.

Supports Python 3.6 and higher.

[Documentation here.](https://sklearn-evaluation.readthedocs.io)

![confusion matrix](examples/cm.png)

![grid search](https://sklearn-evaluation.readthedocs.io/en/stable/_images/gs_1.png)

# Install  

```bash
pip install sklearn-evaluation
```

# Features

* [Plotting](https://sklearn-evaluation.readthedocs.io/en/stable/_images/cm.png) (confusion matrix, feature importances, precision-recall, roc)
* Report generation ([example](https://htmlpreview.github.io/?https://github.com/ploomber/sklearn-evaluation/blob/master/examples/report.html))
* [Evaluate grid search results](https://sklearn-evaluation.readthedocs.io/en/stable/user_guide/grid_search.html)
* [Track experiments using a local SQLite database](https://sklearn-evaluation.readthedocs.io/en/stable/user_guide/SQLiteTracker.html)
* [Analyze notebooks output](https://sklearn-evaluation.readthedocs.io/en/stable/user_guide/NotebookCollection.html)
* [Query notebooks with SQL](https://sklearn-evaluation.readthedocs.io/en/stable/user_guide/nbdb.html)

