# coding: utf-8

"""
    Аналитика и данные

    <div class=\"description_important\">   Узнать больше об аналитике и данных можно в <a href=\"https://seller.wildberries.ru/instructions/ru/ru/subcategory/seller-analytics\">справочном центре</a> </div>  В разделе описаны методы получения:   1. [Воронки продаж](/openapi/analytics#tag/Voronka-prodazh)   2. [Поисковых запросов по вашим товарам](/openapi/analytics#tag/Poiskovye-zaprosy-po-vashim-tovaram)   3. [Истории остатков](/openapi/analytics#tag/Istoriya-ostatkov)   4. [Аналитики продавца в формате CSV](/openapi/analytics#tag/Analitika-prodavca-CSV) 

    The version of the OpenAPI document: analytics
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from wildberries_sdk.analytics.models.sales_funnel_group_req import SalesFunnelGroupReq
from wildberries_sdk.analytics.models.sales_funnel_product_req import SalesFunnelProductReq
from wildberries_sdk.analytics.models.search_report_group_req import SearchReportGroupReq
from wildberries_sdk.analytics.models.search_report_product_req import SearchReportProductReq
from wildberries_sdk.analytics.models.search_report_text_req import SearchReportTextReq
from wildberries_sdk.analytics.models.stocks_report_req import StocksReportReq
from pydantic import StrictStr, Field
from typing import Union, List, Set, Optional, Dict
from typing_extensions import Literal, Self

APIV2NMREPORTDOWNLOADSPOSTREQUEST_ONE_OF_SCHEMAS = ["SalesFunnelGroupReq", "SalesFunnelProductReq", "SearchReportGroupReq", "SearchReportProductReq", "SearchReportTextReq", "StocksReportReq"]

class ApiV2NmReportDownloadsPostRequest(BaseModel):
    """
    ApiV2NmReportDownloadsPostRequest
    """
    # data type: SalesFunnelProductReq
    oneof_schema_1_validator: Optional[SalesFunnelProductReq] = None
    # data type: SalesFunnelGroupReq
    oneof_schema_2_validator: Optional[SalesFunnelGroupReq] = None
    # data type: SearchReportGroupReq
    oneof_schema_3_validator: Optional[SearchReportGroupReq] = None
    # data type: SearchReportProductReq
    oneof_schema_4_validator: Optional[SearchReportProductReq] = None
    # data type: SearchReportTextReq
    oneof_schema_5_validator: Optional[SearchReportTextReq] = None
    # data type: StocksReportReq
    oneof_schema_6_validator: Optional[StocksReportReq] = None
    actual_instance: Optional[Union[SalesFunnelGroupReq, SalesFunnelProductReq, SearchReportGroupReq, SearchReportProductReq, SearchReportTextReq, StocksReportReq]] = None
    one_of_schemas: Set[str] = { "SalesFunnelGroupReq", "SalesFunnelProductReq", "SearchReportGroupReq", "SearchReportProductReq", "SearchReportTextReq", "StocksReportReq" }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    discriminator_value_class_map: Dict[str, str] = {
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = ApiV2NmReportDownloadsPostRequest.model_construct()
        error_messages = []
        match = 0
        # validate data type: SalesFunnelProductReq
        if not isinstance(v, SalesFunnelProductReq):
            error_messages.append(f"Error! Input type `{type(v)}` is not `SalesFunnelProductReq`")
        else:
            match += 1
        # validate data type: SalesFunnelGroupReq
        if not isinstance(v, SalesFunnelGroupReq):
            error_messages.append(f"Error! Input type `{type(v)}` is not `SalesFunnelGroupReq`")
        else:
            match += 1
        # validate data type: SearchReportGroupReq
        if not isinstance(v, SearchReportGroupReq):
            error_messages.append(f"Error! Input type `{type(v)}` is not `SearchReportGroupReq`")
        else:
            match += 1
        # validate data type: SearchReportProductReq
        if not isinstance(v, SearchReportProductReq):
            error_messages.append(f"Error! Input type `{type(v)}` is not `SearchReportProductReq`")
        else:
            match += 1
        # validate data type: SearchReportTextReq
        if not isinstance(v, SearchReportTextReq):
            error_messages.append(f"Error! Input type `{type(v)}` is not `SearchReportTextReq`")
        else:
            match += 1
        # validate data type: StocksReportReq
        if not isinstance(v, StocksReportReq):
            error_messages.append(f"Error! Input type `{type(v)}` is not `StocksReportReq`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in ApiV2NmReportDownloadsPostRequest with oneOf schemas: SalesFunnelGroupReq, SalesFunnelProductReq, SearchReportGroupReq, SearchReportProductReq, SearchReportTextReq, StocksReportReq. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in ApiV2NmReportDownloadsPostRequest with oneOf schemas: SalesFunnelGroupReq, SalesFunnelProductReq, SearchReportGroupReq, SearchReportProductReq, SearchReportTextReq, StocksReportReq. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # deserialize data into SalesFunnelProductReq
        try:
            instance.actual_instance = SalesFunnelProductReq.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into SalesFunnelGroupReq
        try:
            instance.actual_instance = SalesFunnelGroupReq.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into SearchReportGroupReq
        try:
            instance.actual_instance = SearchReportGroupReq.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into SearchReportProductReq
        try:
            instance.actual_instance = SearchReportProductReq.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into SearchReportTextReq
        try:
            instance.actual_instance = SearchReportTextReq.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into StocksReportReq
        try:
            instance.actual_instance = StocksReportReq.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into ApiV2NmReportDownloadsPostRequest with oneOf schemas: SalesFunnelGroupReq, SalesFunnelProductReq, SearchReportGroupReq, SearchReportProductReq, SearchReportTextReq, StocksReportReq. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into ApiV2NmReportDownloadsPostRequest with oneOf schemas: SalesFunnelGroupReq, SalesFunnelProductReq, SearchReportGroupReq, SearchReportProductReq, SearchReportTextReq, StocksReportReq. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], SalesFunnelGroupReq, SalesFunnelProductReq, SearchReportGroupReq, SearchReportProductReq, SearchReportTextReq, StocksReportReq]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


