# coding: utf-8

"""
    Аналитика и данные

    <div class=\"description_important\">   Узнать больше об аналитике и данных можно в <a href=\"https://seller.wildberries.ru/instructions/ru/ru/subcategory/seller-analytics\">справочном центре</a> </div>  В разделе описаны методы получения:   1. [Воронки продаж](/openapi/analytics#tag/Voronka-prodazh)   2. [Поисковых запросов по вашим товарам](/openapi/analytics#tag/Poiskovye-zaprosy-po-vashim-tovaram)   3. [Истории остатков](/openapi/analytics#tag/Istoriya-ostatkov)   4. [Аналитики продавца в формате CSV](/openapi/analytics#tag/Analitika-prodavca-CSV) 

    The version of the OpenAPI document: analytics
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from wildberries_sdk.analytics.models.period_st import PeriodSt
from wildberries_sdk.analytics.models.stock_type import StockType
from wildberries_sdk.analytics.models.table_order_by import TableOrderBy
from typing import Optional, Set
from typing_extensions import Self

class CommonReportFilters(BaseModel):
    """
    Общие фильтры по отчёту
    """ # noqa: E501
    nm_ids: Optional[List[StrictInt]] = Field(default=None, description="Список артикулов WB для фильтрации", alias="nmIDs")
    subject_ids: Optional[List[StrictInt]] = Field(default=None, description="Список ID предметов для фильтрации", alias="subjectIDs")
    brand_names: Optional[List[StrictStr]] = Field(default=None, description="Список брендов для фильтрации", alias="brandNames")
    tag_ids: Optional[List[StrictInt]] = Field(default=None, description="Список ID ярлыков для фильтрации", alias="tagIDs")
    current_period: PeriodSt = Field(alias="currentPeriod")
    stock_type: StockType = Field(alias="stockType")
    skip_deleted_nm: StrictBool = Field(description="Скрыть удалённые товары", alias="skipDeletedNm")
    availability_filters: List[StrictStr] = Field(description="Доступность товара:   - `deficient` — Дефицит   - `actual` — Актуальный   - `balanced` — Баланс   - `nonActual` — Неактуальный   - `nonLiquid` — Неликвид   - `invalidData` — Не рассчитано ", alias="availabilityFilters")
    order_by: TableOrderBy = Field(alias="orderBy")
    __properties: ClassVar[List[str]] = ["nmIDs", "subjectIDs", "brandNames", "tagIDs", "currentPeriod", "stockType", "skipDeletedNm", "availabilityFilters", "orderBy"]

    @field_validator('availability_filters')
    def availability_filters_validate_enum(cls, value):
        """Validates the enum"""
        for i in value:
            if i not in set(['deficient', 'actual', 'balanced', 'nonActual', 'nonLiquid', 'invalidData']):
                raise ValueError("each list item must be one of ('deficient', 'actual', 'balanced', 'nonActual', 'nonLiquid', 'invalidData')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CommonReportFilters from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of current_period
        if self.current_period:
            _dict['currentPeriod'] = self.current_period.to_dict()
        # override the default output from pydantic by calling `to_dict()` of order_by
        if self.order_by:
            _dict['orderBy'] = self.order_by.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CommonReportFilters from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "nmIDs": obj.get("nmIDs"),
            "subjectIDs": obj.get("subjectIDs"),
            "brandNames": obj.get("brandNames"),
            "tagIDs": obj.get("tagIDs"),
            "currentPeriod": PeriodSt.from_dict(obj["currentPeriod"]) if obj.get("currentPeriod") is not None else None,
            "stockType": obj.get("stockType"),
            "skipDeletedNm": obj.get("skipDeletedNm"),
            "availabilityFilters": obj.get("availabilityFilters"),
            "orderBy": TableOrderBy.from_dict(obj["orderBy"]) if obj.get("orderBy") is not None else None
        })
        return _obj


