# coding: utf-8

"""
    Аналитика и данные

    <div class=\"description_important\">   Узнать больше об аналитике и данных можно в <a href=\"https://seller.wildberries.ru/instructions/ru/ru/subcategory/seller-analytics\">справочном центре</a> </div>  В разделе описаны методы получения:   1. [Воронки продаж](/openapi/analytics#tag/Voronka-prodazh)   2. [Поисковых запросов по вашим товарам](/openapi/analytics#tag/Poiskovye-zaprosy-po-vashim-tovaram)   3. [Истории остатков](/openapi/analytics#tag/Istoriya-ostatkov)   4. [Аналитики продавца в формате CSV](/openapi/analytics#tag/Analitika-prodavca-CSV) 

    The version of the OpenAPI document: analytics
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List
from wildberries_sdk.analytics.models.comparison_time_to_ready_dynamic import ComparisonTimeToReadyDynamic
from wildberries_sdk.analytics.models.comparison_wb_club_dynamic import ComparisonWbClubDynamic
from wildberries_sdk.analytics.models.statistic_conversions import StatisticConversions
from typing import Optional, Set
from typing_extensions import Self

class Comparison(BaseModel):
    """
    Comparison
    """ # noqa: E501
    open_count_dynamic: StrictInt = Field(description="Динамика переходов в карточку товара", alias="openCountDynamic")
    cart_count_dynamic: StrictInt = Field(description="Динамика добавлений в корзину", alias="cartCountDynamic")
    order_count_dynamic: StrictInt = Field(description="Динамика количества заказов", alias="orderCountDynamic")
    order_sum_dynamic: StrictInt = Field(description="Динамика суммы заказов", alias="orderSumDynamic")
    buyout_count_dynamic: StrictInt = Field(description="Динамика выкупов", alias="buyoutCountDynamic")
    buyout_sum_dynamic: StrictInt = Field(description="Динамика суммы выкупов", alias="buyoutSumDynamic")
    cancel_count_dynamic: StrictInt = Field(description="Динамика отмен товаров", alias="cancelCountDynamic")
    cancel_sum_dynamic: StrictInt = Field(description="Динамика сумм отмен товаров", alias="cancelSumDynamic")
    avg_orders_count_per_day_dynamic: StrictInt = Field(description="Динамика среднего количества заказов в день", alias="avgOrdersCountPerDayDynamic")
    avg_price_dynamic: StrictInt = Field(description="Динамика средней цены на товары. Учитываются скидки для акций", alias="avgPriceDynamic")
    share_order_percent_dynamic: StrictInt = Field(description="Динамика доли в выручке", alias="shareOrderPercentDynamic")
    add_to_wishlist_dynamic: StrictInt = Field(description="Динамика добавлений товара в избранное", alias="addToWishlistDynamic")
    time_to_ready_dynamic: ComparisonTimeToReadyDynamic = Field(alias="timeToReadyDynamic")
    localization_percent_dynamic: StrictInt = Field(description="Динамика локальных заказов в рамках одного региона", alias="localizationPercentDynamic")
    wb_club_dynamic: ComparisonWbClubDynamic = Field(alias="wbClubDynamic")
    conversions: StatisticConversions
    __properties: ClassVar[List[str]] = ["openCountDynamic", "cartCountDynamic", "orderCountDynamic", "orderSumDynamic", "buyoutCountDynamic", "buyoutSumDynamic", "cancelCountDynamic", "cancelSumDynamic", "avgOrdersCountPerDayDynamic", "avgPriceDynamic", "shareOrderPercentDynamic", "addToWishlistDynamic", "timeToReadyDynamic", "localizationPercentDynamic", "wbClubDynamic", "conversions"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Comparison from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of time_to_ready_dynamic
        if self.time_to_ready_dynamic:
            _dict['timeToReadyDynamic'] = self.time_to_ready_dynamic.to_dict()
        # override the default output from pydantic by calling `to_dict()` of wb_club_dynamic
        if self.wb_club_dynamic:
            _dict['wbClubDynamic'] = self.wb_club_dynamic.to_dict()
        # override the default output from pydantic by calling `to_dict()` of conversions
        if self.conversions:
            _dict['conversions'] = self.conversions.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Comparison from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "openCountDynamic": obj.get("openCountDynamic"),
            "cartCountDynamic": obj.get("cartCountDynamic"),
            "orderCountDynamic": obj.get("orderCountDynamic"),
            "orderSumDynamic": obj.get("orderSumDynamic"),
            "buyoutCountDynamic": obj.get("buyoutCountDynamic"),
            "buyoutSumDynamic": obj.get("buyoutSumDynamic"),
            "cancelCountDynamic": obj.get("cancelCountDynamic"),
            "cancelSumDynamic": obj.get("cancelSumDynamic"),
            "avgOrdersCountPerDayDynamic": obj.get("avgOrdersCountPerDayDynamic"),
            "avgPriceDynamic": obj.get("avgPriceDynamic"),
            "shareOrderPercentDynamic": obj.get("shareOrderPercentDynamic"),
            "addToWishlistDynamic": obj.get("addToWishlistDynamic"),
            "timeToReadyDynamic": ComparisonTimeToReadyDynamic.from_dict(obj["timeToReadyDynamic"]) if obj.get("timeToReadyDynamic") is not None else None,
            "localizationPercentDynamic": obj.get("localizationPercentDynamic"),
            "wbClubDynamic": ComparisonWbClubDynamic.from_dict(obj["wbClubDynamic"]) if obj.get("wbClubDynamic") is not None else None,
            "conversions": StatisticConversions.from_dict(obj["conversions"]) if obj.get("conversions") is not None else None
        })
        return _obj


