# coding: utf-8

"""
    Аналитика и данные

    <div class=\"description_important\">   Узнать больше об аналитике и данных можно в <a href=\"https://seller.wildberries.ru/instructions/ru/ru/subcategory/seller-analytics\">справочном центре</a> </div>  В разделе описаны методы получения:   1. [Воронки продаж](/openapi/analytics#tag/Voronka-prodazh)   2. [Поисковых запросов по вашим товарам](/openapi/analytics#tag/Poiskovye-zaprosy-po-vashim-tovaram)   3. [Истории остатков](/openapi/analytics#tag/Istoriya-ostatkov)   4. [Аналитики продавца в формате CSV](/openapi/analytics#tag/Analitika-prodavca-CSV) 

    The version of the OpenAPI document: analytics
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from wildberries_sdk.analytics.models.level import Level
from wildberries_sdk.analytics.models.products_request_selected_period import ProductsRequestSelectedPeriod
from typing import Optional, Set
from typing_extensions import Self

class GroupedHistoryRequest(BaseModel):
    """
    GroupedHistoryRequest
    """ # noqa: E501
    selected_period: ProductsRequestSelectedPeriod = Field(alias="selectedPeriod")
    brand_names: Optional[List[StrictStr]] = Field(default=None, description="Список брендов для фильтрации", alias="brandNames")
    subject_ids: Optional[List[StrictInt]] = Field(default=None, description="Список ID предметов для фильтрации", alias="subjectIds")
    tag_ids: Optional[List[StrictInt]] = Field(default=None, description="Список ID ярлыков для фильтрации", alias="tagIds")
    skip_deleted_nm: Optional[StrictBool] = Field(default=None, description="Скрыть удалённые карточки товаров", alias="skipDeletedNm")
    aggregation_level: Optional[Level] = Field(default=Level.DAY, alias="aggregationLevel")
    __properties: ClassVar[List[str]] = ["selectedPeriod", "brandNames", "subjectIds", "tagIds", "skipDeletedNm", "aggregationLevel"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GroupedHistoryRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of selected_period
        if self.selected_period:
            _dict['selectedPeriod'] = self.selected_period.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GroupedHistoryRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "selectedPeriod": ProductsRequestSelectedPeriod.from_dict(obj["selectedPeriod"]) if obj.get("selectedPeriod") is not None else None,
            "brandNames": obj.get("brandNames"),
            "subjectIds": obj.get("subjectIds"),
            "tagIds": obj.get("tagIds"),
            "skipDeletedNm": obj.get("skipDeletedNm"),
            "aggregationLevel": obj.get("aggregationLevel") if obj.get("aggregationLevel") is not None else Level.DAY
        })
        return _obj


