# coding: utf-8

"""
    Аналитика и данные

    <div class=\"description_important\">   Узнать больше об аналитике и данных можно в <a href=\"https://seller.wildberries.ru/instructions/ru/ru/subcategory/seller-analytics\">справочном центре</a> </div>  В разделе описаны методы получения:   1. [Воронки продаж](/openapi/analytics#tag/Voronka-prodazh)   2. [Поисковых запросов по вашим товарам](/openapi/analytics#tag/Poiskovye-zaprosy-po-vashim-tovaram)   3. [Истории остатков](/openapi/analytics#tag/Istoriya-ostatkov)   4. [Аналитики продавца в формате CSV](/openapi/analytics#tag/Analitika-prodavca-CSV) 

    The version of the OpenAPI document: analytics
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import date
from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List
from typing import Optional, Set
from typing_extensions import Self

class History(BaseModel):
    """
    History
    """ # noqa: E501
    var_date: date = Field(description="Дата сбора статистики", alias="date")
    open_count: StrictInt = Field(description="Количество переходов в карточку товара", alias="openCount")
    cart_count: StrictInt = Field(description="Положили в корзину, шт.", alias="cartCount")
    order_count: StrictInt = Field(description="Заказали товаров, шт.", alias="orderCount")
    order_sum: StrictInt = Field(description="Заказали на сумму", alias="orderSum")
    buyout_count: StrictInt = Field(description="Выкупили товаров, шт.", alias="buyoutCount")
    buyout_sum: StrictInt = Field(description="Выкупили на сумму", alias="buyoutSum")
    buyout_percent: StrictInt = Field(description="Процент выкупа", alias="buyoutPercent")
    add_to_cart_conversion: StrictInt = Field(description="Конверсия в корзину. Какой процент посетителей, открывших карточку товара, добавили товар в корзину, %", alias="addToCartConversion")
    cart_to_order_conversion: StrictInt = Field(description="Конверсия в заказ. Какой процент посетителей, добавивших товар в корзину, сделали заказ", alias="cartToOrderConversion")
    add_to_wishlist_count: StrictInt = Field(description="Количество добавлений товара в **Отложенные**", alias="addToWishlistCount")
    __properties: ClassVar[List[str]] = ["date", "openCount", "cartCount", "orderCount", "orderSum", "buyoutCount", "buyoutSum", "buyoutPercent", "addToCartConversion", "cartToOrderConversion", "addToWishlistCount"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of History from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of History from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "date": obj.get("date"),
            "openCount": obj.get("openCount"),
            "cartCount": obj.get("cartCount"),
            "orderCount": obj.get("orderCount"),
            "orderSum": obj.get("orderSum"),
            "buyoutCount": obj.get("buyoutCount"),
            "buyoutSum": obj.get("buyoutSum"),
            "buyoutPercent": obj.get("buyoutPercent"),
            "addToCartConversion": obj.get("addToCartConversion"),
            "cartToOrderConversion": obj.get("cartToOrderConversion"),
            "addToWishlistCount": obj.get("addToWishlistCount")
        })
        return _obj


