# coding: utf-8

"""
    Аналитика и данные

    <div class=\"description_important\">   Узнать больше об аналитике и данных можно в <a href=\"https://seller.wildberries.ru/instructions/ru/ru/subcategory/seller-analytics\">справочном центре</a> </div>  В разделе описаны методы получения:   1. [Воронки продаж](/openapi/analytics#tag/Voronka-prodazh)   2. [Поисковых запросов по вашим товарам](/openapi/analytics#tag/Poiskovye-zaprosy-po-vashim-tovaram)   3. [Истории остатков](/openapi/analytics#tag/Istoriya-ostatkov)   4. [Аналитики продавца в формате CSV](/openapi/analytics#tag/Analitika-prodavca-CSV) 

    The version of the OpenAPI document: analytics
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from wildberries_sdk.analytics.models.order_by_main_and_details import OrderByMainAndDetails
from wildberries_sdk.analytics.models.past_period import PastPeriod
from wildberries_sdk.analytics.models.period import Period
from wildberries_sdk.analytics.models.position_cluster import PositionCluster
from typing import Optional, Set
from typing_extensions import Self

class MainRequest(BaseModel):
    """
    Параметры запроса для формирования главной страницы:   - `currentPeriod` — текущий период   - `pastPeriod` — предыдущий период для сравнения 
    """ # noqa: E501
    current_period: Period = Field(alias="currentPeriod")
    past_period: Optional[PastPeriod] = Field(default=None, alias="pastPeriod")
    nm_ids: Optional[List[StrictInt]] = Field(default=None, description="Список артикулов WB для фильтрации", alias="nmIds")
    subject_ids: Optional[List[StrictInt]] = Field(default=None, description="Список ID предметов для фильтрации", alias="subjectIds")
    brand_names: Optional[List[StrictStr]] = Field(default=None, description="Список брендов для фильтрации", alias="brandNames")
    tag_ids: Optional[List[StrictInt]] = Field(default=None, description="Список ID ярлыков для фильтрации", alias="tagIds")
    position_cluster: PositionCluster = Field(alias="positionCluster")
    order_by: OrderByMainAndDetails = Field(alias="orderBy")
    include_substituted_skus: Optional[StrictBool] = Field(default=True, description="Показать данные по прямым запросам с [подменным артикулом](https://seller.wildberries.ru/help-center/article/A-524)", alias="includeSubstitutedSKUs")
    include_search_texts: Optional[StrictBool] = Field(default=True, description="Показать данные по поисковым запросам без учёта подменного артикула", alias="includeSearchTexts")
    limit: Annotated[int, Field(le=1000, strict=True)] = Field(description="Количество групп товаров в ответе")
    offset: StrictInt = Field(description="После какого элемента выдавать данные")
    __properties: ClassVar[List[str]] = ["currentPeriod", "pastPeriod", "nmIds", "subjectIds", "brandNames", "tagIds", "positionCluster", "orderBy", "includeSubstitutedSKUs", "includeSearchTexts", "limit", "offset"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MainRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of current_period
        if self.current_period:
            _dict['currentPeriod'] = self.current_period.to_dict()
        # override the default output from pydantic by calling `to_dict()` of past_period
        if self.past_period:
            _dict['pastPeriod'] = self.past_period.to_dict()
        # override the default output from pydantic by calling `to_dict()` of order_by
        if self.order_by:
            _dict['orderBy'] = self.order_by.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MainRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "currentPeriod": Period.from_dict(obj["currentPeriod"]) if obj.get("currentPeriod") is not None else None,
            "pastPeriod": PastPeriod.from_dict(obj["pastPeriod"]) if obj.get("pastPeriod") is not None else None,
            "nmIds": obj.get("nmIds"),
            "subjectIds": obj.get("subjectIds"),
            "brandNames": obj.get("brandNames"),
            "tagIds": obj.get("tagIds"),
            "positionCluster": obj.get("positionCluster"),
            "orderBy": OrderByMainAndDetails.from_dict(obj["orderBy"]) if obj.get("orderBy") is not None else None,
            "includeSubstitutedSKUs": obj.get("includeSubstitutedSKUs") if obj.get("includeSubstitutedSKUs") is not None else True,
            "includeSearchTexts": obj.get("includeSearchTexts") if obj.get("includeSearchTexts") is not None else True,
            "limit": obj.get("limit"),
            "offset": obj.get("offset")
        })
        return _obj


