# coding: utf-8

"""
    Аналитика и данные

    <div class=\"description_important\">   Узнать больше об аналитике и данных можно в <a href=\"https://seller.wildberries.ru/instructions/ru/ru/subcategory/seller-analytics\">справочном центре</a> </div>  В разделе описаны методы получения:   1. [Воронки продаж](/openapi/analytics#tag/Voronka-prodazh)   2. [Поисковых запросов по вашим товарам](/openapi/analytics#tag/Poiskovye-zaprosy-po-vashim-tovaram)   3. [Истории остатков](/openapi/analytics#tag/Istoriya-ostatkov)   4. [Аналитики продавца в формате CSV](/openapi/analytics#tag/Analitika-prodavca-CSV) 

    The version of the OpenAPI document: analytics
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from wildberries_sdk.analytics.models.common_info import CommonInfo
from wildberries_sdk.analytics.models.position_info import PositionInfo
from wildberries_sdk.analytics.models.table_group_item import TableGroupItem
from wildberries_sdk.analytics.models.visibility_info import VisibilityInfo
from typing import Optional, Set
from typing_extensions import Self

class MainResponse(BaseModel):
    """
    MainResponse
    """ # noqa: E501
    common_info: CommonInfo = Field(alias="commonInfo")
    position_info: PositionInfo = Field(alias="positionInfo")
    visibility_info: VisibilityInfo = Field(alias="visibilityInfo")
    groups: Optional[List[TableGroupItem]] = Field(default=None, description="Список элементов таблицы ")
    __properties: ClassVar[List[str]] = ["commonInfo", "positionInfo", "visibilityInfo", "groups"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MainResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of common_info
        if self.common_info:
            _dict['commonInfo'] = self.common_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of position_info
        if self.position_info:
            _dict['positionInfo'] = self.position_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of visibility_info
        if self.visibility_info:
            _dict['visibilityInfo'] = self.visibility_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in groups (list)
        _items = []
        if self.groups:
            for _item_groups in self.groups:
                if _item_groups:
                    _items.append(_item_groups.to_dict())
            _dict['groups'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MainResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "commonInfo": CommonInfo.from_dict(obj["commonInfo"]) if obj.get("commonInfo") is not None else None,
            "positionInfo": PositionInfo.from_dict(obj["positionInfo"]) if obj.get("positionInfo") is not None else None,
            "visibilityInfo": VisibilityInfo.from_dict(obj["visibilityInfo"]) if obj.get("visibilityInfo") is not None else None,
            "groups": [TableGroupItem.from_dict(_item) for _item in obj["groups"]] if obj.get("groups") is not None else None
        })
        return _obj


