# coding: utf-8

"""
    Аналитика и данные

    <div class=\"description_important\">   Узнать больше об аналитике и данных можно в <a href=\"https://seller.wildberries.ru/instructions/ru/ru/subcategory/seller-analytics\">справочном центре</a> </div>  В разделе описаны методы получения:   1. [Воронки продаж](/openapi/analytics#tag/Voronka-prodazh)   2. [Поисковых запросов по вашим товарам](/openapi/analytics#tag/Poiskovye-zaprosy-po-vashim-tovaram)   3. [Истории остатков](/openapi/analytics#tag/Istoriya-ostatkov)   4. [Аналитики продавца в формате CSV](/openapi/analytics#tag/Analitika-prodavca-CSV) 

    The version of the OpenAPI document: analytics
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Union
from wildberries_sdk.analytics.models.product_stocks import ProductStocks
from wildberries_sdk.analytics.models.tag import Tag
from typing import Optional, Set
from typing_extensions import Self

class Product(BaseModel):
    """
    Product
    """ # noqa: E501
    nm_id: StrictInt = Field(description="Артикул WB", alias="nmId")
    title: StrictStr = Field(description="Название карточки товара")
    vendor_code: StrictStr = Field(description="Артикул продавца", alias="vendorCode")
    brand_name: StrictStr = Field(description="Бренд", alias="brandName")
    subject_id: StrictInt = Field(description="ID предмета", alias="subjectId")
    subject_name: StrictStr = Field(description="Название предмета", alias="subjectName")
    tags: List[Tag] = Field(description="Ярлыки")
    product_rating: Union[StrictFloat, StrictInt] = Field(description="Оценка карточки", alias="productRating")
    feedback_rating: Union[StrictFloat, StrictInt] = Field(description="Оценка пользователей", alias="feedbackRating")
    stocks: ProductStocks
    __properties: ClassVar[List[str]] = ["nmId", "title", "vendorCode", "brandName", "subjectId", "subjectName", "tags", "productRating", "feedbackRating", "stocks"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Product from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in tags (list)
        _items = []
        if self.tags:
            for _item_tags in self.tags:
                if _item_tags:
                    _items.append(_item_tags.to_dict())
            _dict['tags'] = _items
        # override the default output from pydantic by calling `to_dict()` of stocks
        if self.stocks:
            _dict['stocks'] = self.stocks.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Product from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "nmId": obj.get("nmId"),
            "title": obj.get("title"),
            "vendorCode": obj.get("vendorCode"),
            "brandName": obj.get("brandName"),
            "subjectId": obj.get("subjectId"),
            "subjectName": obj.get("subjectName"),
            "tags": [Tag.from_dict(_item) for _item in obj["tags"]] if obj.get("tags") is not None else None,
            "productRating": obj.get("productRating"),
            "feedbackRating": obj.get("feedbackRating"),
            "stocks": ProductStocks.from_dict(obj["stocks"]) if obj.get("stocks") is not None else None
        })
        return _obj


