# coding: utf-8

"""
    Аналитика и данные

    <div class=\"description_important\">   Узнать больше об аналитике и данных можно в <a href=\"https://seller.wildberries.ru/instructions/ru/ru/subcategory/seller-analytics\">справочном центре</a> </div>  В разделе описаны методы получения:   1. [Воронки продаж](/openapi/analytics#tag/Voronka-prodazh)   2. [Поисковых запросов по вашим товарам](/openapi/analytics#tag/Poiskovye-zaprosy-po-vashim-tovaram)   3. [Истории остатков](/openapi/analytics#tag/Istoriya-ostatkov)   4. [Аналитики продавца в формате CSV](/openapi/analytics#tag/Analitika-prodavca-CSV) 

    The version of the OpenAPI document: analytics
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from wildberries_sdk.analytics.models.order_by import OrderBy
from wildberries_sdk.analytics.models.products_request_past_period import ProductsRequestPastPeriod
from wildberries_sdk.analytics.models.products_request_selected_period import ProductsRequestSelectedPeriod
from typing import Optional, Set
from typing_extensions import Self

class ProductsRequest(BaseModel):
    """
    ProductsRequest
    """ # noqa: E501
    selected_period: ProductsRequestSelectedPeriod = Field(alias="selectedPeriod")
    past_period: Optional[ProductsRequestPastPeriod] = Field(default=None, alias="pastPeriod")
    nm_ids: Optional[Annotated[List[StrictInt], Field(min_length=0, max_length=1000)]] = Field(default=None, description="Артикулы WB, по которым нужно составить отчёт. Оставьте пустым, чтобы получить отчёт обо всех товарах ", alias="nmIds")
    brand_names: Optional[List[StrictStr]] = Field(default=None, description="Список брендов для фильтрации", alias="brandNames")
    subject_ids: Optional[List[StrictInt]] = Field(default=None, description="Список ID предметов для фильтрации", alias="subjectIds")
    tag_ids: Optional[List[StrictInt]] = Field(default=None, description="Список ID ярлыков для фильтрации", alias="tagIds")
    skip_deleted_nm: Optional[StrictBool] = Field(default=None, description="Скрыть удалённые карточки товаров", alias="skipDeletedNm")
    order_by: Optional[OrderBy] = Field(default=None, alias="orderBy")
    limit: Optional[Annotated[int, Field(le=1000, strict=True)]] = Field(default=50, description="Количество карточек товара в ответе")
    offset: Optional[StrictInt] = Field(default=0, description="Сколько элементов пропустить. Например, для значения `10` ответ начнется с 11 элемента")
    __properties: ClassVar[List[str]] = ["selectedPeriod", "pastPeriod", "nmIds", "brandNames", "subjectIds", "tagIds", "skipDeletedNm", "orderBy", "limit", "offset"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ProductsRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of selected_period
        if self.selected_period:
            _dict['selectedPeriod'] = self.selected_period.to_dict()
        # override the default output from pydantic by calling `to_dict()` of past_period
        if self.past_period:
            _dict['pastPeriod'] = self.past_period.to_dict()
        # override the default output from pydantic by calling `to_dict()` of order_by
        if self.order_by:
            _dict['orderBy'] = self.order_by.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ProductsRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "selectedPeriod": ProductsRequestSelectedPeriod.from_dict(obj["selectedPeriod"]) if obj.get("selectedPeriod") is not None else None,
            "pastPeriod": ProductsRequestPastPeriod.from_dict(obj["pastPeriod"]) if obj.get("pastPeriod") is not None else None,
            "nmIds": obj.get("nmIds"),
            "brandNames": obj.get("brandNames"),
            "subjectIds": obj.get("subjectIds"),
            "tagIds": obj.get("tagIds"),
            "skipDeletedNm": obj.get("skipDeletedNm"),
            "orderBy": OrderBy.from_dict(obj["orderBy"]) if obj.get("orderBy") is not None else None,
            "limit": obj.get("limit") if obj.get("limit") is not None else 50,
            "offset": obj.get("offset") if obj.get("offset") is not None else 0
        })
        return _obj


