# coding: utf-8

"""
    Аналитика и данные

    <div class=\"description_important\">   Узнать больше об аналитике и данных можно в <a href=\"https://seller.wildberries.ru/instructions/ru/ru/subcategory/seller-analytics\">справочном центре</a> </div>  В разделе описаны методы получения:   1. [Воронки продаж](/openapi/analytics#tag/Voronka-prodazh)   2. [Поисковых запросов по вашим товарам](/openapi/analytics#tag/Poiskovye-zaprosy-po-vashim-tovaram)   3. [Истории остатков](/openapi/analytics#tag/Istoriya-ostatkov)   4. [Аналитики продавца в формате CSV](/openapi/analytics#tag/Analitika-prodavca-CSV) 

    The version of the OpenAPI document: analytics
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Union
from wildberries_sdk.analytics.models.date_period import DatePeriod
from wildberries_sdk.analytics.models.statistic_conversions import StatisticConversions
from wildberries_sdk.analytics.models.statistic_time_to_ready import StatisticTimeToReady
from wildberries_sdk.analytics.models.statistic_wb_club import StatisticWbClub
from typing import Optional, Set
from typing_extensions import Self

class Statistic(BaseModel):
    """
    Statistic
    """ # noqa: E501
    period: DatePeriod = Field(description="Даты периода")
    open_count: StrictInt = Field(description="Количество переходов в карточку товара", alias="openCount")
    cart_count: StrictInt = Field(description="Положили в корзину, шт.", alias="cartCount")
    order_count: StrictInt = Field(description="Заказали товаров, шт.", alias="orderCount")
    order_sum: StrictInt = Field(description="Заказали на сумму", alias="orderSum")
    buyout_count: StrictInt = Field(description="Выкупили товаров, шт.", alias="buyoutCount")
    buyout_sum: StrictInt = Field(description="Выкупили на сумму", alias="buyoutSum")
    cancel_count: StrictInt = Field(description="Отменили товаров, шт.", alias="cancelCount")
    cancel_sum: StrictInt = Field(description="Отменили на сумму", alias="cancelSum")
    avg_price: StrictInt = Field(description="Средняя цена", alias="avgPrice")
    avg_orders_count_per_day: Union[StrictFloat, StrictInt] = Field(description="Среднее количество заказов в день, шт.", alias="avgOrdersCountPerDay")
    share_order_percent: Union[StrictFloat, StrictInt] = Field(description="Доля в выручке", alias="shareOrderPercent")
    add_to_wishlist: StrictInt = Field(description="Добавили в **Отложенные**", alias="addToWishlist")
    time_to_ready: StatisticTimeToReady = Field(alias="timeToReady")
    localization_percent: StrictInt = Field(description="Локальные заказы в рамках одного региона", alias="localizationPercent")
    wb_club: StatisticWbClub = Field(alias="wbClub")
    conversions: StatisticConversions
    __properties: ClassVar[List[str]] = ["period", "openCount", "cartCount", "orderCount", "orderSum", "buyoutCount", "buyoutSum", "cancelCount", "cancelSum", "avgPrice", "avgOrdersCountPerDay", "shareOrderPercent", "addToWishlist", "timeToReady", "localizationPercent", "wbClub", "conversions"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Statistic from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of period
        if self.period:
            _dict['period'] = self.period.to_dict()
        # override the default output from pydantic by calling `to_dict()` of time_to_ready
        if self.time_to_ready:
            _dict['timeToReady'] = self.time_to_ready.to_dict()
        # override the default output from pydantic by calling `to_dict()` of wb_club
        if self.wb_club:
            _dict['wbClub'] = self.wb_club.to_dict()
        # override the default output from pydantic by calling `to_dict()` of conversions
        if self.conversions:
            _dict['conversions'] = self.conversions.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Statistic from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "period": DatePeriod.from_dict(obj["period"]) if obj.get("period") is not None else None,
            "openCount": obj.get("openCount"),
            "cartCount": obj.get("cartCount"),
            "orderCount": obj.get("orderCount"),
            "orderSum": obj.get("orderSum"),
            "buyoutCount": obj.get("buyoutCount"),
            "buyoutSum": obj.get("buyoutSum"),
            "cancelCount": obj.get("cancelCount"),
            "cancelSum": obj.get("cancelSum"),
            "avgPrice": obj.get("avgPrice"),
            "avgOrdersCountPerDay": obj.get("avgOrdersCountPerDay"),
            "shareOrderPercent": obj.get("shareOrderPercent"),
            "addToWishlist": obj.get("addToWishlist"),
            "timeToReady": StatisticTimeToReady.from_dict(obj["timeToReady"]) if obj.get("timeToReady") is not None else None,
            "localizationPercent": obj.get("localizationPercent"),
            "wbClub": StatisticWbClub.from_dict(obj["wbClub"]) if obj.get("wbClub") is not None else None,
            "conversions": StatisticConversions.from_dict(obj["conversions"]) if obj.get("conversions") is not None else None
        })
        return _obj


