# coding: utf-8

"""
    Аналитика и данные

    <div class=\"description_important\">   Узнать больше об аналитике и данных можно в <a href=\"https://seller.wildberries.ru/instructions/ru/ru/subcategory/seller-analytics\">справочном центре</a> </div>  В разделе описаны методы получения:   1. [Воронки продаж](/openapi/analytics#tag/Voronka-prodazh)   2. [Поисковых запросов по вашим товарам](/openapi/analytics#tag/Poiskovye-zaprosy-po-vashim-tovaram)   3. [Истории остатков](/openapi/analytics#tag/Istoriya-ostatkov)   4. [Аналитики продавца в формате CSV](/openapi/analytics#tag/Analitika-prodavca-CSV) 

    The version of the OpenAPI document: analytics
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Union
from wildberries_sdk.analytics.models.float_graph_by_period_item import FloatGraphByPeriodItem
from wildberries_sdk.analytics.models.table_common_metrics_avg_stock_turnover import TableCommonMetricsAvgStockTurnover
from wildberries_sdk.analytics.models.table_common_metrics_office_missing_time import TableCommonMetricsOfficeMissingTime
from wildberries_sdk.analytics.models.table_common_metrics_sale_rate import TableCommonMetricsSaleRate
from typing import Optional, Set
from typing_extensions import Self

class TableCommonMetrics(BaseModel):
    """
    Метрики
    """ # noqa: E501
    orders_count: StrictInt = Field(description="Заказы, шт.", alias="ordersCount")
    orders_sum: StrictInt = Field(description="Заказы, сумма", alias="ordersSum")
    avg_orders: Union[StrictFloat, StrictInt] = Field(description="Среднее количество заказов в день", alias="avgOrders")
    avg_orders_by_month: List[FloatGraphByPeriodItem] = Field(description="Среднее количество заказов по месяцам", alias="avgOrdersByMonth")
    buyout_count: StrictInt = Field(description="Выкупы, шт.", alias="buyoutCount")
    buyout_sum: StrictInt = Field(description="Выкупы, сумма", alias="buyoutSum")
    buyout_percent: StrictInt = Field(description="Процент выкупа", alias="buyoutPercent")
    stock_count: StrictInt = Field(description="Остатки на текущий день, шт.", alias="stockCount")
    stock_sum: StrictInt = Field(description="Стоимость остатков на текущий день", alias="stockSum")
    sale_rate: TableCommonMetricsSaleRate = Field(alias="saleRate")
    avg_stock_turnover: TableCommonMetricsAvgStockTurnover = Field(alias="avgStockTurnover")
    to_client_count: StrictInt = Field(description="В пути к клиенту, шт.", alias="toClientCount")
    from_client_count: StrictInt = Field(description="В пути от клиента, шт.", alias="fromClientCount")
    office_missing_time: TableCommonMetricsOfficeMissingTime = Field(alias="officeMissingTime")
    lost_orders_count: Union[StrictFloat, StrictInt] = Field(description="Упущенные заказы, шт. Особые случаи:   1. Значение меньше `0` и не равно `-2` — значение не рассчитано   2. Значение `-2` — нулевое значение ", alias="lostOrdersCount")
    lost_orders_sum: Union[StrictFloat, StrictInt] = Field(description="Упущенные заказы, сумма. Особые случаи:   1. Значение меньше `0` и не равно `-2` — значение не рассчитано   2. Значение `-2` — нулевое значение ", alias="lostOrdersSum")
    lost_buyouts_count: Union[StrictFloat, StrictInt] = Field(description="Упущенные выкупы, шт. Особые случаи:   1. Значение меньше `0` и не равно `-2` — значение не рассчитано   2. Значение `-2` — нулевое значение ", alias="lostBuyoutsCount")
    lost_buyouts_sum: Union[StrictFloat, StrictInt] = Field(description="Упущенные выкупы, сумма. Особые случаи:   1. Значение меньше `0` и не равно `-2` — значение не рассчитано   2. Значение `-2` — нулевое значение ", alias="lostBuyoutsSum")
    __properties: ClassVar[List[str]] = ["ordersCount", "ordersSum", "avgOrders", "avgOrdersByMonth", "buyoutCount", "buyoutSum", "buyoutPercent", "stockCount", "stockSum", "saleRate", "avgStockTurnover", "toClientCount", "fromClientCount", "officeMissingTime", "lostOrdersCount", "lostOrdersSum", "lostBuyoutsCount", "lostBuyoutsSum"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TableCommonMetrics from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in avg_orders_by_month (list)
        _items = []
        if self.avg_orders_by_month:
            for _item_avg_orders_by_month in self.avg_orders_by_month:
                if _item_avg_orders_by_month:
                    _items.append(_item_avg_orders_by_month.to_dict())
            _dict['avgOrdersByMonth'] = _items
        # override the default output from pydantic by calling `to_dict()` of sale_rate
        if self.sale_rate:
            _dict['saleRate'] = self.sale_rate.to_dict()
        # override the default output from pydantic by calling `to_dict()` of avg_stock_turnover
        if self.avg_stock_turnover:
            _dict['avgStockTurnover'] = self.avg_stock_turnover.to_dict()
        # override the default output from pydantic by calling `to_dict()` of office_missing_time
        if self.office_missing_time:
            _dict['officeMissingTime'] = self.office_missing_time.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TableCommonMetrics from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "ordersCount": obj.get("ordersCount"),
            "ordersSum": obj.get("ordersSum"),
            "avgOrders": obj.get("avgOrders"),
            "avgOrdersByMonth": [FloatGraphByPeriodItem.from_dict(_item) for _item in obj["avgOrdersByMonth"]] if obj.get("avgOrdersByMonth") is not None else None,
            "buyoutCount": obj.get("buyoutCount"),
            "buyoutSum": obj.get("buyoutSum"),
            "buyoutPercent": obj.get("buyoutPercent"),
            "stockCount": obj.get("stockCount"),
            "stockSum": obj.get("stockSum"),
            "saleRate": TableCommonMetricsSaleRate.from_dict(obj["saleRate"]) if obj.get("saleRate") is not None else None,
            "avgStockTurnover": TableCommonMetricsAvgStockTurnover.from_dict(obj["avgStockTurnover"]) if obj.get("avgStockTurnover") is not None else None,
            "toClientCount": obj.get("toClientCount"),
            "fromClientCount": obj.get("fromClientCount"),
            "officeMissingTime": TableCommonMetricsOfficeMissingTime.from_dict(obj["officeMissingTime"]) if obj.get("officeMissingTime") is not None else None,
            "lostOrdersCount": obj.get("lostOrdersCount"),
            "lostOrdersSum": obj.get("lostOrdersSum"),
            "lostBuyoutsCount": obj.get("lostBuyoutsCount"),
            "lostBuyoutsSum": obj.get("lostBuyoutsSum")
        })
        return _obj


