# coding: utf-8

"""
    Аналитика и данные

    <div class=\"description_important\">   Узнать больше об аналитике и данных можно в <a href=\"https://seller.wildberries.ru/instructions/ru/ru/subcategory/seller-analytics\">справочном центре</a> </div>  В разделе описаны методы получения:   1. [Воронки продаж](/openapi/analytics#tag/Voronka-prodazh)   2. [Поисковых запросов по вашим товарам](/openapi/analytics#tag/Poiskovye-zaprosy-po-vashim-tovaram)   3. [Истории остатков](/openapi/analytics#tag/Istoriya-ostatkov)   4. [Аналитики продавца в формате CSV](/openapi/analytics#tag/Analitika-prodavca-CSV) 

    The version of the OpenAPI document: analytics
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List
from wildberries_sdk.analytics.models.table_common_metrics import TableCommonMetrics
from wildberries_sdk.analytics.models.table_product_item_st import TableProductItemSt
from typing import Optional, Set
from typing_extensions import Self

class TableGroupItemSt(BaseModel):
    """
    Данные по группе
    """ # noqa: E501
    subject_id: StrictInt = Field(description="ID предмета", alias="subjectID")
    subject_name: StrictStr = Field(description="Название предмета", alias="subjectName")
    brand_name: StrictStr = Field(description="Бренд", alias="brandName")
    tag_id: StrictInt = Field(description="ID ярлыка", alias="tagID")
    tag_name: StrictStr = Field(description="Название ярлыка", alias="tagName")
    metrics: TableCommonMetrics = Field(description="Метрики группы")
    items: List[TableProductItemSt] = Field(description="Товары группы")
    __properties: ClassVar[List[str]] = ["subjectID", "subjectName", "brandName", "tagID", "tagName", "metrics", "items"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TableGroupItemSt from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of metrics
        if self.metrics:
            _dict['metrics'] = self.metrics.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in items (list)
        _items = []
        if self.items:
            for _item_items in self.items:
                if _item_items:
                    _items.append(_item_items.to_dict())
            _dict['items'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TableGroupItemSt from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "subjectID": obj.get("subjectID"),
            "subjectName": obj.get("subjectName"),
            "brandName": obj.get("brandName"),
            "tagID": obj.get("tagID"),
            "tagName": obj.get("tagName"),
            "metrics": TableCommonMetrics.from_dict(obj["metrics"]) if obj.get("metrics") is not None else None,
            "items": [TableProductItemSt.from_dict(_item) for _item in obj["items"]] if obj.get("items") is not None else None
        })
        return _obj


