# coding: utf-8

"""
    Аналитика и данные

    <div class=\"description_important\">   Узнать больше об аналитике и данных можно в <a href=\"https://seller.wildberries.ru/instructions/ru/ru/subcategory/seller-analytics\">справочном центре</a> </div>  В разделе описаны методы получения:   1. [Воронки продаж](/openapi/analytics#tag/Voronka-prodazh)   2. [Поисковых запросов по вашим товарам](/openapi/analytics#tag/Poiskovye-zaprosy-po-vashim-tovaram)   3. [Истории остатков](/openapi/analytics#tag/Istoriya-ostatkov)   4. [Аналитики продавца в формате CSV](/openapi/analytics#tag/Analitika-prodavca-CSV) 

    The version of the OpenAPI document: analytics
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from wildberries_sdk.analytics.models.table_group_item_metrics_add_to_cart import TableGroupItemMetricsAddToCart
from wildberries_sdk.analytics.models.table_group_item_metrics_avg_position import TableGroupItemMetricsAvgPosition
from wildberries_sdk.analytics.models.table_group_item_metrics_cart_to_order import TableGroupItemMetricsCartToOrder
from wildberries_sdk.analytics.models.table_group_item_metrics_open_to_cart import TableGroupItemMetricsOpenToCart
from wildberries_sdk.analytics.models.table_group_item_metrics_orders import TableGroupItemMetricsOrders
from wildberries_sdk.analytics.models.table_group_item_metrics_visibility import TableGroupItemMetricsVisibility
from wildberries_sdk.analytics.models.table_product_item_all_of_price import TableProductItemAllOfPrice
from wildberries_sdk.analytics.models.visibility_info_open_card import VisibilityInfoOpenCard
from typing import Optional, Set
from typing_extensions import Self

class TableProductItem(BaseModel):
    """
    TableProductItem
    """ # noqa: E501
    nm_id: StrictInt = Field(description="Артикул WB", alias="nmId")
    name: Optional[StrictStr] = Field(default=None, description="Название товара")
    vendor_code: StrictStr = Field(description="Артикул продавца", alias="vendorCode")
    subject_name: Optional[StrictStr] = Field(default=None, description="Название предмета", alias="subjectName")
    brand_name: Optional[StrictStr] = Field(default=None, description="Бренд", alias="brandName")
    main_photo: Optional[StrictStr] = Field(default=None, description="URL главного фото карточки товара", alias="mainPhoto")
    is_advertised: StrictBool = Field(description="Находится ли товар в продвижении в Поисковой выдаче", alias="isAdvertised")
    is_substituted_sku: Optional[StrictBool] = Field(default=None, description="Искали ли товар по подменному артикулу.<br> Поле будет в ответе при наличии в запросе `includeSubstitutedSKUs` и/или `includeSearchTexts` ", alias="isSubstitutedSKU")
    is_card_rated: StrictBool = Field(description="Есть ли рейтинг у карточки товара", alias="isCardRated")
    rating: Union[StrictFloat, StrictInt] = Field(description="Рейтинг карточки товара")
    feedback_rating: Union[StrictFloat, StrictInt] = Field(description="Рейтинг по отзывам", alias="feedbackRating")
    price: TableProductItemAllOfPrice
    avg_position: TableGroupItemMetricsAvgPosition = Field(alias="avgPosition")
    open_card: VisibilityInfoOpenCard = Field(alias="openCard")
    add_to_cart: TableGroupItemMetricsAddToCart = Field(alias="addToCart")
    open_to_cart: TableGroupItemMetricsOpenToCart = Field(alias="openToCart")
    orders: TableGroupItemMetricsOrders
    cart_to_order: TableGroupItemMetricsCartToOrder = Field(alias="cartToOrder")
    visibility: TableGroupItemMetricsVisibility
    __properties: ClassVar[List[str]] = ["nmId", "name", "vendorCode", "subjectName", "brandName", "mainPhoto", "isAdvertised", "isSubstitutedSKU", "isCardRated", "rating", "feedbackRating", "price", "avgPosition", "openCard", "addToCart", "openToCart", "orders", "cartToOrder", "visibility"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TableProductItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of price
        if self.price:
            _dict['price'] = self.price.to_dict()
        # override the default output from pydantic by calling `to_dict()` of avg_position
        if self.avg_position:
            _dict['avgPosition'] = self.avg_position.to_dict()
        # override the default output from pydantic by calling `to_dict()` of open_card
        if self.open_card:
            _dict['openCard'] = self.open_card.to_dict()
        # override the default output from pydantic by calling `to_dict()` of add_to_cart
        if self.add_to_cart:
            _dict['addToCart'] = self.add_to_cart.to_dict()
        # override the default output from pydantic by calling `to_dict()` of open_to_cart
        if self.open_to_cart:
            _dict['openToCart'] = self.open_to_cart.to_dict()
        # override the default output from pydantic by calling `to_dict()` of orders
        if self.orders:
            _dict['orders'] = self.orders.to_dict()
        # override the default output from pydantic by calling `to_dict()` of cart_to_order
        if self.cart_to_order:
            _dict['cartToOrder'] = self.cart_to_order.to_dict()
        # override the default output from pydantic by calling `to_dict()` of visibility
        if self.visibility:
            _dict['visibility'] = self.visibility.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TableProductItem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "nmId": obj.get("nmId"),
            "name": obj.get("name"),
            "vendorCode": obj.get("vendorCode"),
            "subjectName": obj.get("subjectName"),
            "brandName": obj.get("brandName"),
            "mainPhoto": obj.get("mainPhoto"),
            "isAdvertised": obj.get("isAdvertised"),
            "isSubstitutedSKU": obj.get("isSubstitutedSKU"),
            "isCardRated": obj.get("isCardRated"),
            "rating": obj.get("rating"),
            "feedbackRating": obj.get("feedbackRating"),
            "price": TableProductItemAllOfPrice.from_dict(obj["price"]) if obj.get("price") is not None else None,
            "avgPosition": TableGroupItemMetricsAvgPosition.from_dict(obj["avgPosition"]) if obj.get("avgPosition") is not None else None,
            "openCard": VisibilityInfoOpenCard.from_dict(obj["openCard"]) if obj.get("openCard") is not None else None,
            "addToCart": TableGroupItemMetricsAddToCart.from_dict(obj["addToCart"]) if obj.get("addToCart") is not None else None,
            "openToCart": TableGroupItemMetricsOpenToCart.from_dict(obj["openToCart"]) if obj.get("openToCart") is not None else None,
            "orders": TableGroupItemMetricsOrders.from_dict(obj["orders"]) if obj.get("orders") is not None else None,
            "cartToOrder": TableGroupItemMetricsCartToOrder.from_dict(obj["cartToOrder"]) if obj.get("cartToOrder") is not None else None,
            "visibility": TableGroupItemMetricsVisibility.from_dict(obj["visibility"]) if obj.get("visibility") is not None else None
        })
        return _obj


