# coding: utf-8

"""
    Общение с покупателями

    <div class=\"description_important\">     Узнать больше об общении с покупателями можно в <a href=\"https://seller.wildberries.ru/instructions/category/f7f6c465-dd12-422d-80a0-a6d9562115d5?goBackOption=prevRoute&categoryId=30817062-14cc-4a82-bc78-3600c2b0685b\">справочном центре</a> </div>  С помощью методов общения с покупателями вы можете работать с:   1. [Вопросами](/openapi/user-communication#tag/Voprosy) и [отзывами](/openapi/user-communication#tag/Otzyvy) покупателей   2. [Закреплёнными отзывами](/openapi/user-communication#tag/Zakreplyonnye-otzyvy)   3. [Чатами с покупателями](/openapi/user-communication#tag/Chat-s-pokupatelyami)   4. [Заявками покупателей на возврат](/openapi/user-communication#tag/Vozvraty-pokupatelyami) 

    The version of the OpenAPI document: communication
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class ApiV1ClaimsGet200ResponseClaimsInner(BaseModel):
    """
    ApiV1ClaimsGet200ResponseClaimsInner
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="ID заявки")
    claim_type: Optional[StrictInt] = Field(default=None, description="Источник заявки:   * `1` — портал покупателей   * `3` — чат ")
    status: Optional[StrictInt] = Field(default=None, description="Решение по возврату покупателю:   * `0` — на рассмотрении   * `1` — отказ   * `2` — одобрено ")
    status_ex: Optional[StrictInt] = Field(default=None, description="Статус товара:   * `0` — заявка на рассмотрении   * `1` — товар остается у покупателя (Заявка отклонена)   * `2` — покупатель сдает товар на WB, товар отправляется в утиль   * `5` — товар остается у покупателя (Заявка одобрена)   * `8` — товар будет возвращён в реализацию после проверки WB   * `10` — товар возвращается продавцу ")
    nm_id: Optional[StrictInt] = Field(default=None, description="Артикул WB")
    user_comment: Optional[Annotated[str, Field(strict=True, max_length=1000)]] = Field(default=None, description="Комментарий покупателя")
    wb_comment: Optional[Annotated[str, Field(strict=True, max_length=10000)]] = Field(default=None, description="Ответ покупателю")
    dt: Optional[datetime] = Field(default=None, description="Дата и время оформления заявки покупателем")
    imt_name: Optional[StrictStr] = Field(default=None, description="Название товара")
    order_dt: Optional[datetime] = Field(default=None, description="Дата и время заказа")
    dt_update: Optional[datetime] = Field(default=None, description="Дата и время рассмотрения заявки. Для нерассмотренной заявки — дата и время оформления")
    photos: Optional[Annotated[List[StrictStr], Field(min_length=0, max_length=10)]] = Field(default=None, description="Фотографии из заявки покупателя")
    video_paths: Optional[Annotated[List[StrictStr], Field(min_length=0, max_length=1)]] = Field(default=None, description="Видео из заявки покупателя")
    actions: Optional[List[StrictStr]] = Field(default=None, description="Варианты [ответа продавца на заявку](./user-communication#tag/Vozvraty-pokupatelyami/paths/~1api~1v1~1claim/patch).<br>Отклонённые заявки можно пересмотреть. Если массив пуст, с заявкой работать нельзя.   * `approve1` — одобрить с проверкой брака.<br>Деньги вернутся покупателю после возврата товара. Товар будет проверен на складе. При подтверждении брака/ошибки вложения товар будет отправлен продавцу. Если брак/ошибка вложения не подтвердятся, товар будет возвращён в продажу.<br>Неприменимо при модели <strong>[Самовывоз](./in-store-pickup)</strong>.   * `approve2` — одобрить и забрать товар.<br> Деньги вернутся покупателю после возврата товара. Товар будет отправлен продавцу.<br>Неприменимо при модели <strong>[Самовывоз](./in-store-pickup)</strong>.   * `autorefund1` — одобрить без возврата товара.<br> Товар останется у покупателя. Деньги за него будут возвращены покупателю без возврата товара.   * `reject1` — отклонить с шаблоном ответа: <details><summary><strong>Брак не обнаружен</strong></summary>Пришлось отклонить заявку — подтвердить производственный брак не получилось. Можете отнести товар на независимую экспертизу или в сервисный центр. Если брак подтвердится, создайте новую заявку с такой же причиной, ещё раз опишите проблему и добавьте фото заключения. А если остались вопросы, задайте их в чате: нажмите кнопку «Написать продавцу».</details>   * `reject2` — отклонить с шаблоном ответа: <details><summary><strong>Добавить фото/видео</strong></summary>Пришлось отклонить заявку — нужно чуть больше информации. Создайте новую заявку с такой же причиной возврата, подробно опишите проблему и добавьте фото, на которых хорошо видно: сам товар целиком, брак, бирку или этикетку, упаковку со штрихкодом Wildberries, если она осталась. Желательно добавить видео — это поможет разобраться.</details>   * `reject3` — отклонить с шаблоном ответа: <details><summary><strong>Направить в сервисный центр</strong></summary>Пришлось отклонить заявку — подтвердить производственный брак не получилось. Вы можете отнести товар в сервисный центр: адрес есть на сайте производителя или в гарантийном талоне. Там всё проверят и выдадут заключение. Если производственный брак подтвердится, создайте новую заявку с такой же причиной, ещё раз опишите проблему и добавьте фото заключения.</details>   * `rejectcustom` — отклонить с комментарием.<br>Комментарий передаётся в параметре `comment`.   * `approvecc1` — одобрить заявку с возвратом товара в магазин продавца.<br>Можно передать комментарий (например, телефон для связи или время работы своего отдела возвратов) в параметре `comment`. По итогу возврата необходимо ответить на заявку с `\"action\":\"confirmreturngoodcc1\"` или `\"action\":\"rejectcustom\"`.<br>Применимо только при модели <strong>[Самовывоз](./in-store-pickup)</strong>.   * `confirmreturngoodcc1` — подтвердить приёмку товара от покупателя.<br>Применимо только при модели <strong>[Самовывоз](./in-store-pickup)</strong>. ")
    price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Фактическая цена с учетом всех скидок. Взимается с покупателя")
    currency_code: Optional[StrictStr] = Field(default=None, description="Код валюты цены")
    srid: Optional[StrictStr] = Field(default=None, description="Уникальный ID заказа, по товару которого создана заявка")
    __properties: ClassVar[List[str]] = ["id", "claim_type", "status", "status_ex", "nm_id", "user_comment", "wb_comment", "dt", "imt_name", "order_dt", "dt_update", "photos", "video_paths", "actions", "price", "currency_code", "srid"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ApiV1ClaimsGet200ResponseClaimsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if wb_comment (nullable) is None
        # and model_fields_set contains the field
        if self.wb_comment is None and "wb_comment" in self.model_fields_set:
            _dict['wb_comment'] = None

        # set to None if imt_name (nullable) is None
        # and model_fields_set contains the field
        if self.imt_name is None and "imt_name" in self.model_fields_set:
            _dict['imt_name'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ApiV1ClaimsGet200ResponseClaimsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "claim_type": obj.get("claim_type"),
            "status": obj.get("status"),
            "status_ex": obj.get("status_ex"),
            "nm_id": obj.get("nm_id"),
            "user_comment": obj.get("user_comment"),
            "wb_comment": obj.get("wb_comment"),
            "dt": obj.get("dt"),
            "imt_name": obj.get("imt_name"),
            "order_dt": obj.get("order_dt"),
            "dt_update": obj.get("dt_update"),
            "photos": obj.get("photos"),
            "video_paths": obj.get("video_paths"),
            "actions": obj.get("actions"),
            "price": obj.get("price"),
            "currency_code": obj.get("currency_code"),
            "srid": obj.get("srid")
        })
        return _obj


