# coding: utf-8

"""
    Общение с покупателями

    <div class=\"description_important\">     Узнать больше об общении с покупателями можно в <a href=\"https://seller.wildberries.ru/instructions/category/f7f6c465-dd12-422d-80a0-a6d9562115d5?goBackOption=prevRoute&categoryId=30817062-14cc-4a82-bc78-3600c2b0685b\">справочном центре</a> </div>  С помощью методов общения с покупателями вы можете работать с:   1. [Вопросами](/openapi/user-communication#tag/Voprosy) и [отзывами](/openapi/user-communication#tag/Otzyvy) покупателей   2. [Закреплёнными отзывами](/openapi/user-communication#tag/Zakreplyonnye-otzyvy)   3. [Чатами с покупателями](/openapi/user-communication#tag/Chat-s-pokupatelyami)   4. [Заявками покупателей на возврат](/openapi/user-communication#tag/Vozvraty-pokupatelyami) 

    The version of the OpenAPI document: communication
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from wildberries_sdk.communications.models.api_v1_feedback_get200_response_data_answer import ApiV1FeedbackGet200ResponseDataAnswer
from wildberries_sdk.communications.models.api_v1_feedback_get200_response_data_photo_links_inner import ApiV1FeedbackGet200ResponseDataPhotoLinksInner
from wildberries_sdk.communications.models.api_v1_feedback_get200_response_data_product_details import ApiV1FeedbackGet200ResponseDataProductDetails
from wildberries_sdk.communications.models.api_v1_feedback_get200_response_data_video import ApiV1FeedbackGet200ResponseDataVideo
from typing import Optional, Set
from typing_extensions import Self

class ApiV1FeedbackGet200ResponseData(BaseModel):
    """
    ApiV1FeedbackGet200ResponseData
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="ID отзыва")
    user_name: Optional[StrictStr] = Field(default=None, description="Имя автора отзыва", alias="userName")
    pros: Optional[StrictStr] = Field(default=None, description="Достоинства товара")
    cons: Optional[StrictStr] = Field(default=None, description="Недостатки товара")
    matching_size: Optional[StrictStr] = Field(default=None, description="Соответствие заявленного размера реальному. <br>Возможные значения: - ` ` - для безразмерных товаров - `ок` - соответствует размеру - `smaller` - маломерит - `bigger` - большемерит ", alias="matchingSize")
    text: Optional[StrictStr] = Field(default=None, description="Текст отзыва")
    product_valuation: Optional[StrictInt] = Field(default=None, description="Оценка товара", alias="productValuation")
    created_date: Optional[datetime] = Field(default=None, description="Дата и время создания отзыва", alias="createdDate")
    answer: Optional[ApiV1FeedbackGet200ResponseDataAnswer] = None
    state: Optional[StrictStr] = Field(default=None, description="Статус отзыва:   - `none` - не обработан (новый)   - `wbRu` - обработан ")
    product_details: Optional[ApiV1FeedbackGet200ResponseDataProductDetails] = Field(default=None, alias="productDetails")
    photo_links: Optional[List[ApiV1FeedbackGet200ResponseDataPhotoLinksInner]] = Field(default=None, description="Массив структур фотографий", alias="photoLinks")
    video: Optional[ApiV1FeedbackGet200ResponseDataVideo] = None
    was_viewed: Optional[StrictBool] = Field(default=None, description="Просмотрен ли отзыв", alias="wasViewed")
    is_able_supplier_feedback_valuation: Optional[StrictBool] = Field(default=None, description="Доступна ли продавцу возможность оставить жалобу на отзыв:   - `true`— да   - `false` — нет ", alias="isAbleSupplierFeedbackValuation")
    supplier_feedback_valuation: Optional[StrictInt] = Field(default=None, description="Ключ причины жалобы на отзыв ", alias="supplierFeedbackValuation")
    is_able_supplier_product_valuation: Optional[StrictBool] = Field(default=None, description="Доступна ли продавцу возможность сообщить о проблеме с товаром  (`true` - доступна, `false` - не доступна)", alias="isAbleSupplierProductValuation")
    supplier_product_valuation: Optional[StrictInt] = Field(default=None, description="Ключ проблемы с товаром ", alias="supplierProductValuation")
    is_able_return_product_orders: Optional[StrictBool] = Field(default=None, description="Опция возврата товара:   - `true` — доступна   - `false` — недоступна ", alias="isAbleReturnProductOrders")
    return_product_orders_date: Optional[StrictStr] = Field(default=None, description="Дата и время, когда на запрос возврата был получен ответ со статус-кодом 200.", alias="returnProductOrdersDate")
    bables: Optional[List[StrictStr]] = Field(default=None, description="Список тегов покупателя")
    last_order_shk_id: Optional[StrictInt] = Field(default=None, description="Штрихкод единицы товара", alias="lastOrderShkId")
    last_order_created_at: Optional[StrictStr] = Field(default=None, description="Дата покупки", alias="lastOrderCreatedAt")
    color: Optional[StrictStr] = Field(default=None, description="Цвет товара")
    subject_id: Optional[StrictInt] = Field(default=None, description="ID предмета", alias="subjectId")
    subject_name: Optional[StrictStr] = Field(default=None, description="Название предмета", alias="subjectName")
    parent_feedback_id: Optional[StrictStr] = Field(default=None, description="ID начального отзыва (`null`, если этот отзыв начальный)", alias="parentFeedbackId")
    child_feedback_id: Optional[StrictStr] = Field(default=None, description="ID дополненного отзыва (`null`, если этот отзыв дополненный)", alias="childFeedbackId")
    __properties: ClassVar[List[str]] = ["id", "userName", "pros", "cons", "matchingSize", "text", "productValuation", "createdDate", "answer", "state", "productDetails", "photoLinks", "video", "wasViewed", "isAbleSupplierFeedbackValuation", "supplierFeedbackValuation", "isAbleSupplierProductValuation", "supplierProductValuation", "isAbleReturnProductOrders", "returnProductOrdersDate", "bables", "lastOrderShkId", "lastOrderCreatedAt", "color", "subjectId", "subjectName", "parentFeedbackId", "childFeedbackId"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ApiV1FeedbackGet200ResponseData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of answer
        if self.answer:
            _dict['answer'] = self.answer.to_dict()
        # override the default output from pydantic by calling `to_dict()` of product_details
        if self.product_details:
            _dict['productDetails'] = self.product_details.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in photo_links (list)
        _items = []
        if self.photo_links:
            for _item_photo_links in self.photo_links:
                if _item_photo_links:
                    _items.append(_item_photo_links.to_dict())
            _dict['photoLinks'] = _items
        # override the default output from pydantic by calling `to_dict()` of video
        if self.video:
            _dict['video'] = self.video.to_dict()
        # set to None if answer (nullable) is None
        # and model_fields_set contains the field
        if self.answer is None and "answer" in self.model_fields_set:
            _dict['answer'] = None

        # set to None if photo_links (nullable) is None
        # and model_fields_set contains the field
        if self.photo_links is None and "photo_links" in self.model_fields_set:
            _dict['photoLinks'] = None

        # set to None if video (nullable) is None
        # and model_fields_set contains the field
        if self.video is None and "video" in self.model_fields_set:
            _dict['video'] = None

        # set to None if return_product_orders_date (nullable) is None
        # and model_fields_set contains the field
        if self.return_product_orders_date is None and "return_product_orders_date" in self.model_fields_set:
            _dict['returnProductOrdersDate'] = None

        # set to None if bables (nullable) is None
        # and model_fields_set contains the field
        if self.bables is None and "bables" in self.model_fields_set:
            _dict['bables'] = None

        # set to None if parent_feedback_id (nullable) is None
        # and model_fields_set contains the field
        if self.parent_feedback_id is None and "parent_feedback_id" in self.model_fields_set:
            _dict['parentFeedbackId'] = None

        # set to None if child_feedback_id (nullable) is None
        # and model_fields_set contains the field
        if self.child_feedback_id is None and "child_feedback_id" in self.model_fields_set:
            _dict['childFeedbackId'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ApiV1FeedbackGet200ResponseData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "userName": obj.get("userName"),
            "pros": obj.get("pros"),
            "cons": obj.get("cons"),
            "matchingSize": obj.get("matchingSize"),
            "text": obj.get("text"),
            "productValuation": obj.get("productValuation"),
            "createdDate": obj.get("createdDate"),
            "answer": ApiV1FeedbackGet200ResponseDataAnswer.from_dict(obj["answer"]) if obj.get("answer") is not None else None,
            "state": obj.get("state"),
            "productDetails": ApiV1FeedbackGet200ResponseDataProductDetails.from_dict(obj["productDetails"]) if obj.get("productDetails") is not None else None,
            "photoLinks": [ApiV1FeedbackGet200ResponseDataPhotoLinksInner.from_dict(_item) for _item in obj["photoLinks"]] if obj.get("photoLinks") is not None else None,
            "video": ApiV1FeedbackGet200ResponseDataVideo.from_dict(obj["video"]) if obj.get("video") is not None else None,
            "wasViewed": obj.get("wasViewed"),
            "isAbleSupplierFeedbackValuation": obj.get("isAbleSupplierFeedbackValuation"),
            "supplierFeedbackValuation": obj.get("supplierFeedbackValuation"),
            "isAbleSupplierProductValuation": obj.get("isAbleSupplierProductValuation"),
            "supplierProductValuation": obj.get("supplierProductValuation"),
            "isAbleReturnProductOrders": obj.get("isAbleReturnProductOrders"),
            "returnProductOrdersDate": obj.get("returnProductOrdersDate"),
            "bables": obj.get("bables"),
            "lastOrderShkId": obj.get("lastOrderShkId"),
            "lastOrderCreatedAt": obj.get("lastOrderCreatedAt"),
            "color": obj.get("color"),
            "subjectId": obj.get("subjectId"),
            "subjectName": obj.get("subjectName"),
            "parentFeedbackId": obj.get("parentFeedbackId"),
            "childFeedbackId": obj.get("childFeedbackId")
        })
        return _obj


