# coding: utf-8

"""
    Общение с покупателями

    <div class=\"description_important\">     Узнать больше об общении с покупателями можно в <a href=\"https://seller.wildberries.ru/instructions/category/f7f6c465-dd12-422d-80a0-a6d9562115d5?goBackOption=prevRoute&categoryId=30817062-14cc-4a82-bc78-3600c2b0685b\">справочном центре</a> </div>  С помощью методов общения с покупателями вы можете работать с:   1. [Вопросами](/openapi/user-communication#tag/Voprosy) и [отзывами](/openapi/user-communication#tag/Otzyvy) покупателей   2. [Закреплёнными отзывами](/openapi/user-communication#tag/Zakreplyonnye-otzyvy)   3. [Чатами с покупателями](/openapi/user-communication#tag/Chat-s-pokupatelyami)   4. [Заявками покупателей на возврат](/openapi/user-communication#tag/Vozvraty-pokupatelyami) 

    The version of the OpenAPI document: communication
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from wildberries_sdk.communications.models.api_v1_question_get200_response_data_answer import ApiV1QuestionGet200ResponseDataAnswer
from wildberries_sdk.communications.models.api_v1_question_get200_response_data_product_details import ApiV1QuestionGet200ResponseDataProductDetails
from typing import Optional, Set
from typing_extensions import Self

class ApiV1QuestionGet200ResponseData(BaseModel):
    """
    ApiV1QuestionGet200ResponseData
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="ID вопроса")
    text: Optional[StrictStr] = Field(default=None, description="Текст вопроса")
    created_date: Optional[datetime] = Field(default=None, description="Дата и время создания вопроса", alias="createdDate")
    state: Optional[StrictStr] = Field(default=None, description="Статус вопроса:   - `none` - вопрос отклонён продавцом (такой вопрос не отображается на портале покупателей)   - `wbRu` - ответ предоставлен, вопрос отображается на сайте покупателей   - `suppliersPortalSynch` - новый вопрос ")
    answer: Optional[ApiV1QuestionGet200ResponseDataAnswer] = None
    product_details: Optional[ApiV1QuestionGet200ResponseDataProductDetails] = Field(default=None, alias="productDetails")
    was_viewed: Optional[StrictBool] = Field(default=None, description="Просмотрен ли вопрос", alias="wasViewed")
    is_warned: Optional[StrictBool] = Field(default=None, description="Признак подозрительного вопроса.<br> Если `true`, то вопрос опубликован, но на портале продавцов вы увидите баннер **Сообщение подозрительное** ", alias="isWarned")
    __properties: ClassVar[List[str]] = ["id", "text", "createdDate", "state", "answer", "productDetails", "wasViewed", "isWarned"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ApiV1QuestionGet200ResponseData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of answer
        if self.answer:
            _dict['answer'] = self.answer.to_dict()
        # override the default output from pydantic by calling `to_dict()` of product_details
        if self.product_details:
            _dict['productDetails'] = self.product_details.to_dict()
        # set to None if answer (nullable) is None
        # and model_fields_set contains the field
        if self.answer is None and "answer" in self.model_fields_set:
            _dict['answer'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ApiV1QuestionGet200ResponseData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "text": obj.get("text"),
            "createdDate": obj.get("createdDate"),
            "state": obj.get("state"),
            "answer": ApiV1QuestionGet200ResponseDataAnswer.from_dict(obj["answer"]) if obj.get("answer") is not None else None,
            "productDetails": ApiV1QuestionGet200ResponseDataProductDetails.from_dict(obj["productDetails"]) if obj.get("productDetails") is not None else None,
            "wasViewed": obj.get("wasViewed"),
            "isWarned": obj.get("isWarned")
        })
        return _obj


