# coding: utf-8

"""
    Общение с покупателями

    <div class=\"description_important\">     Узнать больше об общении с покупателями можно в <a href=\"https://seller.wildberries.ru/instructions/category/f7f6c465-dd12-422d-80a0-a6d9562115d5?goBackOption=prevRoute&categoryId=30817062-14cc-4a82-bc78-3600c2b0685b\">справочном центре</a> </div>  С помощью методов общения с покупателями вы можете работать с:   1. [Вопросами](/openapi/user-communication#tag/Voprosy) и [отзывами](/openapi/user-communication#tag/Otzyvy) покупателей   2. [Закреплёнными отзывами](/openapi/user-communication#tag/Zakreplyonnye-otzyvy)   3. [Чатами с покупателями](/openapi/user-communication#tag/Chat-s-pokupatelyami)   4. [Заявками покупателей на возврат](/openapi/user-communication#tag/Vozvraty-pokupatelyami) 

    The version of the OpenAPI document: communication
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from wildberries_sdk.communications.models.openapi_result_err import OpenapiResultErr
from typing import Optional, Set
from typing_extensions import Self

class OpenapiPinReviewItemResultDataInner(BaseModel):
    """
    OpenapiPinReviewItemResultDataInner
    """ # noqa: E501
    feedback_id: StrictStr = Field(description="ID отзыва", alias="feedbackId")
    pin_id: Optional[StrictInt] = Field(default=None, description="ID операции закрепления. Если поле отсутствует — закрепить отзыв не удалось ", alias="pinId")
    pin_method: StrictStr = Field(description="Метод закрепления:   - `subscription` — подписка Джем   - `tariff` — тарифная опция ", alias="pinMethod")
    pin_on: StrictStr = Field(description="Место закрепления отзыва:   - `nm` — карточка товара   - `imt` — объединённая карточка ", alias="pinOn")
    is_errors: StrictBool = Field(description="Есть ли ошибки", alias="isErrors")
    errors: Optional[List[OpenapiResultErr]] = Field(default=None, description="Детали ошибок")
    __properties: ClassVar[List[str]] = ["feedbackId", "pinId", "pinMethod", "pinOn", "isErrors", "errors"]

    @field_validator('pin_method')
    def pin_method_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['tariff', 'subscription']):
            raise ValueError("must be one of enum values ('tariff', 'subscription')")
        return value

    @field_validator('pin_on')
    def pin_on_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['nm', 'imt']):
            raise ValueError("must be one of enum values ('nm', 'imt')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of OpenapiPinReviewItemResultDataInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in errors (list)
        _items = []
        if self.errors:
            for _item_errors in self.errors:
                if _item_errors:
                    _items.append(_item_errors.to_dict())
            _dict['errors'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of OpenapiPinReviewItemResultDataInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "feedbackId": obj.get("feedbackId"),
            "pinId": obj.get("pinId"),
            "pinMethod": obj.get("pinMethod"),
            "pinOn": obj.get("pinOn"),
            "isErrors": obj.get("isErrors"),
            "errors": [OpenapiResultErr.from_dict(_item) for _item in obj["errors"]] if obj.get("errors") is not None else None
        })
        return _obj


