# coding: utf-8

"""
    Общение с покупателями

    <div class=\"description_important\">     Узнать больше об общении с покупателями можно в <a href=\"https://seller.wildberries.ru/instructions/category/f7f6c465-dd12-422d-80a0-a6d9562115d5?goBackOption=prevRoute&categoryId=30817062-14cc-4a82-bc78-3600c2b0685b\">справочном центре</a> </div>  С помощью методов общения с покупателями вы можете работать с:   1. [Вопросами](/openapi/user-communication#tag/Voprosy) и [отзывами](/openapi/user-communication#tag/Otzyvy) покупателей   2. [Закреплёнными отзывами](/openapi/user-communication#tag/Zakreplyonnye-otzyvy)   3. [Чатами с покупателями](/openapi/user-communication#tag/Chat-s-pokupatelyami)   4. [Заявками покупателей на возврат](/openapi/user-communication#tag/Vozvraty-pokupatelyami) 

    The version of the OpenAPI document: communication
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from wildberries_sdk.communications.models.domain_review_pin_method import DomainReviewPinMethod
from wildberries_sdk.communications.models.domain_review_pin_on import DomainReviewPinOn
from wildberries_sdk.communications.models.domain_review_state import DomainReviewState
from typing import Optional, Set
from typing_extensions import Self

class OpenapiPinnedReviewItemResult(BaseModel):
    """
    OpenapiPinnedReviewItemResult
    """ # noqa: E501
    change_state_at: datetime = Field(description="Дата и время закрепления или открепления", alias="changeStateAt")
    imt_id: StrictInt = Field(description="ID объединённой карточки товара", alias="imtId")
    nm_id: StrictInt = Field(description="Артикул WB", alias="nmId")
    pin_id: StrictInt = Field(description="ID операции закрепления отзыва", alias="pinId")
    pin_method: DomainReviewPinMethod = Field(description="Метод закрепления:   - `subscription` — подписка Джем   - `tariff` — тарифная опция ", alias="pinMethod")
    pin_on: DomainReviewPinOn = Field(description="Место закрепления отзыва:   - `nm` — карточка товара   - `imt` — объединённая карточка ", alias="pinOn")
    feedback_id: StrictStr = Field(description="ID отзыва", alias="feedbackId")
    state: DomainReviewState = Field(description="Закреплён ли отзыв:   - `pinned` — да   - `unpinned` — нет ")
    unpinned_cause: Optional[StrictStr] = Field(default=None, description="Причина открепления отзыва:   - `sysTariffUnpinned` — закончилась подписка или тарифная опция   - `sysLimitReached` — закончился общий лимит по подписке   - `sysNoratingUnpinned` — отзыв исключён из рейтинга. Например, удалён или забанен   - `sysAdditionalSlot` — к карточке или к объединённой карточке прикреплено максимальное количество отзывов ", alias="unpinnedCause")
    __properties: ClassVar[List[str]] = ["changeStateAt", "imtId", "nmId", "pinId", "pinMethod", "pinOn", "feedbackId", "state", "unpinnedCause"]

    @field_validator('unpinned_cause')
    def unpinned_cause_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['sysTariffUnpinned', 'sysLimitReached', 'sysNoratingUnpinned', 'sysAdditionalSlot']):
            raise ValueError("must be one of enum values ('sysTariffUnpinned', 'sysLimitReached', 'sysNoratingUnpinned', 'sysAdditionalSlot')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of OpenapiPinnedReviewItemResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of OpenapiPinnedReviewItemResult from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "changeStateAt": obj.get("changeStateAt"),
            "imtId": obj.get("imtId"),
            "nmId": obj.get("nmId"),
            "pinId": obj.get("pinId"),
            "pinMethod": obj.get("pinMethod"),
            "pinOn": obj.get("pinOn"),
            "feedbackId": obj.get("feedbackId"),
            "state": obj.get("state"),
            "unpinnedCause": obj.get("unpinnedCause")
        })
        return _obj


