# coding: utf-8

"""
    Общение с покупателями

    <div class=\"description_important\">     Узнать больше об общении с покупателями можно в <a href=\"https://seller.wildberries.ru/instructions/category/f7f6c465-dd12-422d-80a0-a6d9562115d5?goBackOption=prevRoute&categoryId=30817062-14cc-4a82-bc78-3600c2b0685b\">справочном центре</a> </div>  С помощью методов общения с покупателями вы можете работать с:   1. [Вопросами](/openapi/user-communication#tag/Voprosy) и [отзывами](/openapi/user-communication#tag/Otzyvy) покупателей   2. [Закреплёнными отзывами](/openapi/user-communication#tag/Zakreplyonnye-otzyvy)   3. [Чатами с покупателями](/openapi/user-communication#tag/Chat-s-pokupatelyami)   4. [Заявками покупателей на возврат](/openapi/user-communication#tag/Vozvraty-pokupatelyami) 

    The version of the OpenAPI document: communication
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from wildberries_sdk.communications.models.openapi_seller_limit import OpenapiSellerLimit
from typing import Optional, Set
from typing_extensions import Self

class OpenapiSellerLimitsResponseData(BaseModel):
    """
    OpenapiSellerLimitsResponseData
    """ # noqa: E501
    subscription: Optional[OpenapiSellerLimit] = Field(default=None, description="Лимиты по подписке")
    tariff: Optional[OpenapiSellerLimit] = Field(default=None, description="Лимиты по тарифной опции")
    __properties: ClassVar[List[str]] = ["subscription", "tariff"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of OpenapiSellerLimitsResponseData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of subscription
        if self.subscription:
            _dict['subscription'] = self.subscription.to_dict()
        # override the default output from pydantic by calling `to_dict()` of tariff
        if self.tariff:
            _dict['tariff'] = self.tariff.to_dict()
        # set to None if subscription (nullable) is None
        # and model_fields_set contains the field
        if self.subscription is None and "subscription" in self.model_fields_set:
            _dict['subscription'] = None

        # set to None if tariff (nullable) is None
        # and model_fields_set contains the field
        if self.tariff is None and "tariff" in self.model_fields_set:
            _dict['tariff'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of OpenapiSellerLimitsResponseData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "subscription": OpenapiSellerLimit.from_dict(obj["subscription"]) if obj.get("subscription") is not None else None,
            "tariff": OpenapiSellerLimit.from_dict(obj["tariff"]) if obj.get("tariff") is not None else None
        })
        return _obj


