# coding: utf-8

"""
    Документы и бухгалтерия

    <div class=\"description_important\">     Узнать больше о документах и бухгалтерии можно в <a href=\"https://seller.wildberries.ru/instructions/category/ba929b64-1f89-4426-82d7-ce998ee552bd?goBackOption=prevRoute&categoryId=3c971375-9939-45e8-ab82-376019be8942\">справочном центре</a> </div>  Просмотр [баланса](/openapi/financial-reports-and-accounting#tag/Balans), [финансовых отчётов](/openapi/financial-reports-and-accounting#tag/Finansovye-otchyoty) и [документов](/openapi/financial-reports-and-accounting#tag/Dokumenty) продавца. 

    The version of the OpenAPI document: finances
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import date, datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class DetailReportItem(BaseModel):
    """
    DetailReportItem
    """ # noqa: E501
    realizationreport_id: Optional[StrictInt] = Field(default=None, description="Номер отчёта")
    date_from: Optional[date] = Field(default=None, description="Дата начала отчётного периода")
    date_to: Optional[date] = Field(default=None, description="Дата конца отчётного периода")
    create_dt: Optional[date] = Field(default=None, description="Дата формирования отчёта")
    currency_name: Optional[StrictStr] = Field(default=None, description="Валюта отчёта")
    suppliercontract_code: Optional[Dict[str, Any]] = Field(default=None, description="Договор")
    rrd_id: Optional[StrictInt] = Field(default=None, description="Номер строки")
    gi_id: Optional[StrictInt] = Field(default=None, description="Номер поставки")
    dlv_prc: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Фиксированный коэффициент склада по поставке")
    fix_tariff_date_from: Optional[date] = Field(default=None, description="Дата начала действия фиксации")
    fix_tariff_date_to: Optional[date] = Field(default=None, description="Дата конца действия фиксации")
    subject_name: Optional[StrictStr] = Field(default=None, description="Предмет")
    nm_id: Optional[StrictInt] = Field(default=None, description="Артикул WB")
    brand_name: Optional[StrictStr] = Field(default=None, description="Бренд")
    sa_name: Optional[StrictStr] = Field(default=None, description="Артикул продавца")
    ts_name: Optional[StrictStr] = Field(default=None, description="Размер")
    barcode: Optional[StrictStr] = Field(default=None, description="Баркод")
    doc_type_name: Optional[StrictStr] = Field(default=None, description="Тип документа")
    quantity: Optional[StrictInt] = Field(default=None, description="Количество")
    retail_price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Цена розничная")
    retail_amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Вайлдберриз реализовал Товар (Пр)")
    sale_percent: Optional[StrictInt] = Field(default=None, description="Согласованный продуктовый дисконт, %")
    commission_percent: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Размер кВВ, %")
    office_name: Optional[StrictStr] = Field(default=None, description="Склад")
    supplier_oper_name: Optional[StrictStr] = Field(default=None, description="Обоснование для оплаты")
    order_dt: Optional[datetime] = Field(default=None, description="Дата заказа. <br>Присылается с явным указанием часового пояса")
    sale_dt: Optional[datetime] = Field(default=None, description="Дата продажи. <br>Присылается с явным указанием часового пояса")
    rr_dt: Optional[date] = Field(default=None, description="Дата операции")
    shk_id: Optional[StrictInt] = Field(default=None, description="Штрихкод")
    retail_price_withdisc_rub: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Цена розничная с учётом согласованной скидки")
    delivery_amount: Optional[StrictInt] = Field(default=None, description="Количество доставок")
    return_amount: Optional[StrictInt] = Field(default=None, description="Количество возврата")
    delivery_rub: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Услуги по доставке товара покупателю")
    gi_box_type_name: Optional[StrictStr] = Field(default=None, description="Тип коробов")
    product_discount_for_report: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Итоговая согласованная скидка, %")
    supplier_promo: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Промокод, %")
    ppvz_spp_prc: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Скидка постоянного Покупателя (СПП), %")
    ppvz_kvw_prc_base: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Размер кВВ без НДС, % базовый")
    ppvz_kvw_prc: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Итоговый кВВ без НДС, %")
    sup_rating_prc_up: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Размер снижения кВВ из-за рейтинга, %")
    is_kgvp_v2: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Размер снижения кВВ из-за акции, %")
    ppvz_sales_commission: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Вознаграждение с продаж до вычета услуг поверенного, без НДС")
    ppvz_for_pay: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="К перечислению продавцу за реализованный товар")
    ppvz_reward: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Возмещение за выдачу и возврат товаров на ПВЗ")
    acquiring_fee: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Эквайринг/Комиссии за организацию платежей")
    acquiring_percent: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Размер комиссии за эквайринг/Комиссии за организацию платежей, %")
    payment_processing: Optional[StrictStr] = Field(default=None, description="Тип платежа за Эквайринг/Комиссии за организацию платежей")
    acquiring_bank: Optional[StrictStr] = Field(default=None, description="Наименование банка-эквайера")
    ppvz_vw: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Вознаграждение Вайлдберриз (ВВ), без НДС")
    ppvz_vw_nds: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="НДС с вознаграждения Вайлдберриз")
    ppvz_office_name: Optional[StrictStr] = Field(default=None, description="Наименование офиса доставки")
    ppvz_office_id: Optional[StrictInt] = Field(default=None, description="Номер офиса доставки")
    ppvz_supplier_id: Optional[StrictInt] = Field(default=None, description="Номер партнёра")
    ppvz_supplier_name: Optional[StrictStr] = Field(default=None, description="Партнёр")
    ppvz_inn: Optional[StrictStr] = Field(default=None, description="ИНН партнёра")
    declaration_number: Optional[StrictStr] = Field(default=None, description="Номер таможенной декларации")
    bonus_type_name: Optional[StrictStr] = Field(default=None, description="Виды логистики, штрафов и корректировок ВВ.<br> Поле будет в ответе при наличии значения ")
    sticker_id: Optional[StrictStr] = Field(default=None, description="Цифровое значение стикера, который клеится на товар в процессе сборки заказа по схеме \"Маркетплейс\"")
    site_country: Optional[StrictStr] = Field(default=None, description="Страна продажи")
    srv_dbs: Optional[StrictBool] = Field(default=None, description="Признак услуги платной доставки")
    penalty: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Общая сумма штрафов")
    additional_payment: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Корректировка Вознаграждения Вайлдберриз (ВВ)")
    rebill_logistic_cost: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Возмещение издержек по перевозке/по складским операциям с товаром")
    rebill_logistic_org: Optional[StrictStr] = Field(default=None, description="Организатор перевозки.<br> Поле будет в ответе при наличии значения ")
    storage_fee: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Хранение")
    deduction: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Удержания")
    acceptance: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Операции на приёмке")
    assembly_id: Optional[StrictInt] = Field(default=None, description="Номер сборочного задания")
    kiz: Optional[StrictStr] = Field(default=None, description="Код маркировки.<br> Поле будет в ответе при наличии значения ")
    srid: Optional[StrictStr] = Field(default=None, description="Уникальный ID заказа.  Примечание для использующих API Marketplace: `srid` равен `rid` в ответах методов сборочных заданий. ")
    report_type: Optional[StrictInt] = Field(default=None, description="Тип отчёта:   - `1` — стандартный   - `2` — для уведомления о выкупе ")
    is_legal_entity: Optional[StrictBool] = Field(default=None, description="Признак B2B-продажи")
    trbx_id: Optional[StrictStr] = Field(default=None, description="Номер короба для обработки товара")
    installment_cofinancing_amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Скидка по программе софинансирования")
    wibes_wb_discount_percent: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Скидка Wibes, %")
    cashback_amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Сумма, удержанная за начисленные баллы программы лояльности")
    cashback_discount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Компенсация скидки по программе лояльности")
    cashback_commission_change: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Стоимость участия в программе лояльности")
    order_uid: Optional[StrictStr] = Field(default=None, description="ID транзакции. Заказы в одной корзине покупателя будут иметь одинаковый `order_uid`")
    payment_schedule: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Разовое изменение срока перечисления денежных средств")
    delivery_method: Optional[StrictStr] = Field(default=None, description="Способ продажи и тип товара")
    seller_promo_id: Optional[StrictInt] = Field(default=None, description="ID собственной акции продавца с дополнительной скидкой")
    seller_promo_discount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Размер дополнительной скидки по собственной акции продавца, %")
    loyalty_id: Optional[StrictInt] = Field(default=None, description="ID скидки лояльности от продавца")
    loyalty_discount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Размер скидки лояльности от продавца, %")
    __properties: ClassVar[List[str]] = ["realizationreport_id", "date_from", "date_to", "create_dt", "currency_name", "suppliercontract_code", "rrd_id", "gi_id", "dlv_prc", "fix_tariff_date_from", "fix_tariff_date_to", "subject_name", "nm_id", "brand_name", "sa_name", "ts_name", "barcode", "doc_type_name", "quantity", "retail_price", "retail_amount", "sale_percent", "commission_percent", "office_name", "supplier_oper_name", "order_dt", "sale_dt", "rr_dt", "shk_id", "retail_price_withdisc_rub", "delivery_amount", "return_amount", "delivery_rub", "gi_box_type_name", "product_discount_for_report", "supplier_promo", "ppvz_spp_prc", "ppvz_kvw_prc_base", "ppvz_kvw_prc", "sup_rating_prc_up", "is_kgvp_v2", "ppvz_sales_commission", "ppvz_for_pay", "ppvz_reward", "acquiring_fee", "acquiring_percent", "payment_processing", "acquiring_bank", "ppvz_vw", "ppvz_vw_nds", "ppvz_office_name", "ppvz_office_id", "ppvz_supplier_id", "ppvz_supplier_name", "ppvz_inn", "declaration_number", "bonus_type_name", "sticker_id", "site_country", "srv_dbs", "penalty", "additional_payment", "rebill_logistic_cost", "rebill_logistic_org", "storage_fee", "deduction", "acceptance", "assembly_id", "kiz", "srid", "report_type", "is_legal_entity", "trbx_id", "installment_cofinancing_amount", "wibes_wb_discount_percent", "cashback_amount", "cashback_discount", "cashback_commission_change", "order_uid", "payment_schedule", "delivery_method", "seller_promo_id", "seller_promo_discount", "loyalty_id", "loyalty_discount"]

    @field_validator('report_type')
    def report_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set([1, 2]):
            raise ValueError("must be one of enum values (1, 2)")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DetailReportItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if suppliercontract_code (nullable) is None
        # and model_fields_set contains the field
        if self.suppliercontract_code is None and "suppliercontract_code" in self.model_fields_set:
            _dict['suppliercontract_code'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DetailReportItem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "realizationreport_id": obj.get("realizationreport_id"),
            "date_from": obj.get("date_from"),
            "date_to": obj.get("date_to"),
            "create_dt": obj.get("create_dt"),
            "currency_name": obj.get("currency_name"),
            "suppliercontract_code": obj.get("suppliercontract_code"),
            "rrd_id": obj.get("rrd_id"),
            "gi_id": obj.get("gi_id"),
            "dlv_prc": obj.get("dlv_prc"),
            "fix_tariff_date_from": obj.get("fix_tariff_date_from"),
            "fix_tariff_date_to": obj.get("fix_tariff_date_to"),
            "subject_name": obj.get("subject_name"),
            "nm_id": obj.get("nm_id"),
            "brand_name": obj.get("brand_name"),
            "sa_name": obj.get("sa_name"),
            "ts_name": obj.get("ts_name"),
            "barcode": obj.get("barcode"),
            "doc_type_name": obj.get("doc_type_name"),
            "quantity": obj.get("quantity"),
            "retail_price": obj.get("retail_price"),
            "retail_amount": obj.get("retail_amount"),
            "sale_percent": obj.get("sale_percent"),
            "commission_percent": obj.get("commission_percent"),
            "office_name": obj.get("office_name"),
            "supplier_oper_name": obj.get("supplier_oper_name"),
            "order_dt": obj.get("order_dt"),
            "sale_dt": obj.get("sale_dt"),
            "rr_dt": obj.get("rr_dt"),
            "shk_id": obj.get("shk_id"),
            "retail_price_withdisc_rub": obj.get("retail_price_withdisc_rub"),
            "delivery_amount": obj.get("delivery_amount"),
            "return_amount": obj.get("return_amount"),
            "delivery_rub": obj.get("delivery_rub"),
            "gi_box_type_name": obj.get("gi_box_type_name"),
            "product_discount_for_report": obj.get("product_discount_for_report"),
            "supplier_promo": obj.get("supplier_promo"),
            "ppvz_spp_prc": obj.get("ppvz_spp_prc"),
            "ppvz_kvw_prc_base": obj.get("ppvz_kvw_prc_base"),
            "ppvz_kvw_prc": obj.get("ppvz_kvw_prc"),
            "sup_rating_prc_up": obj.get("sup_rating_prc_up"),
            "is_kgvp_v2": obj.get("is_kgvp_v2"),
            "ppvz_sales_commission": obj.get("ppvz_sales_commission"),
            "ppvz_for_pay": obj.get("ppvz_for_pay"),
            "ppvz_reward": obj.get("ppvz_reward"),
            "acquiring_fee": obj.get("acquiring_fee"),
            "acquiring_percent": obj.get("acquiring_percent"),
            "payment_processing": obj.get("payment_processing"),
            "acquiring_bank": obj.get("acquiring_bank"),
            "ppvz_vw": obj.get("ppvz_vw"),
            "ppvz_vw_nds": obj.get("ppvz_vw_nds"),
            "ppvz_office_name": obj.get("ppvz_office_name"),
            "ppvz_office_id": obj.get("ppvz_office_id"),
            "ppvz_supplier_id": obj.get("ppvz_supplier_id"),
            "ppvz_supplier_name": obj.get("ppvz_supplier_name"),
            "ppvz_inn": obj.get("ppvz_inn"),
            "declaration_number": obj.get("declaration_number"),
            "bonus_type_name": obj.get("bonus_type_name"),
            "sticker_id": obj.get("sticker_id"),
            "site_country": obj.get("site_country"),
            "srv_dbs": obj.get("srv_dbs"),
            "penalty": obj.get("penalty"),
            "additional_payment": obj.get("additional_payment"),
            "rebill_logistic_cost": obj.get("rebill_logistic_cost"),
            "rebill_logistic_org": obj.get("rebill_logistic_org"),
            "storage_fee": obj.get("storage_fee"),
            "deduction": obj.get("deduction"),
            "acceptance": obj.get("acceptance"),
            "assembly_id": obj.get("assembly_id"),
            "kiz": obj.get("kiz"),
            "srid": obj.get("srid"),
            "report_type": obj.get("report_type"),
            "is_legal_entity": obj.get("is_legal_entity"),
            "trbx_id": obj.get("trbx_id"),
            "installment_cofinancing_amount": obj.get("installment_cofinancing_amount"),
            "wibes_wb_discount_percent": obj.get("wibes_wb_discount_percent"),
            "cashback_amount": obj.get("cashback_amount"),
            "cashback_discount": obj.get("cashback_discount"),
            "cashback_commission_change": obj.get("cashback_commission_change"),
            "order_uid": obj.get("order_uid"),
            "payment_schedule": obj.get("payment_schedule"),
            "delivery_method": obj.get("delivery_method"),
            "seller_promo_id": obj.get("seller_promo_id"),
            "seller_promo_discount": obj.get("seller_promo_discount"),
            "loyalty_id": obj.get("loyalty_id"),
            "loyalty_discount": obj.get("loyalty_discount")
        })
        return _obj


