# coding: utf-8

"""
    Общее

    В этом разделе:   - [общая информация о WB API](/openapi/api-information#tag/Vvedenie)   - как [начать работу с WB API](/openapi/api-information#tag/Vvedenie/Kak-nachat-rabotu-s-API)   - как [авторизоваться](/openapi/api-information#tag/Avtorizaciya) и [создавать токены](/openapi/api-information#tag/Avtorizaciya/Kak-sozdat-personalnyj-bazovyj-ili-testovyj-token)   - основные [статус-коды ответов](/openapi/api-information#tag/Vvedenie/Status-kody-HTTP)   - [лимиты запросов](/openapi/api-information#tag/Vvedenie/Limity-zaprosov)   - как обратиться в [поддержку](/openapi/api-information#tag/Vvedenie/Podderzhka)  С помощью методов этого раздела вы можете:   - проверить [подключение к WB API](/openapi/api-information#tag/Proverka-podklyucheniya-k-WB-API/paths/~1ping/get)   - получить [новости портала продавцов](/openapi/api-information#tag/API-novostej/paths/~1api~1communications~1v2~1news/get)   - получить [информацию о продавце](/openapi/api-information#tag/Informaciya-o-prodavce/paths/~1api~1v1~1seller-info/get)   - [управлять пользователями продавца](/openapi/api-information#tag/Upravlenie-polzovatelyami-prodavca) 

    The version of the OpenAPI document: general
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from wildberries_sdk.general.models.access_inner import AccessInner
from wildberries_sdk.general.models.get_users_response_users_inner_invitee_info import GetUsersResponseUsersInnerInviteeInfo
from typing import Optional, Set
from typing_extensions import Self

class GetUsersResponseUsersInner(BaseModel):
    """
    GetUsersResponseUsersInner
    """ # noqa: E501
    id: StrictInt = Field(description="ID пользователя")
    role: StrictStr = Field(description="Роль пользователя:   * `user` — пользователь, который активировал доступ   * ` ` (пустая строка) — пользователь, который не активировал доступ ")
    position: StrictStr = Field(description="Должность пользователя")
    phone: StrictStr = Field(description="Номер телефона пользователя")
    email: StrictStr = Field(description="Email пользователя")
    is_owner: StrictBool = Field(description="Является ли пользователь владельцем профиля продавца", alias="isOwner")
    first_name: StrictStr = Field(description="Имя пользователя", alias="firstName")
    second_name: StrictStr = Field(description="Фамилия пользователя", alias="secondName")
    patronymic: StrictStr = Field(description="Отчество пользователя")
    goods_return: StrictBool = Field(description="Может ли пользователь одобрять возвраты товаров", alias="goodsReturn")
    is_invitee: StrictBool = Field(description="Приглашён ли пользователь", alias="isInvitee")
    invitee_info: Optional[GetUsersResponseUsersInnerInviteeInfo] = Field(alias="inviteeInfo")
    access: List[AccessInner] = Field(description="Настройки доступа к разделам профиля продавца")
    __properties: ClassVar[List[str]] = ["id", "role", "position", "phone", "email", "isOwner", "firstName", "secondName", "patronymic", "goodsReturn", "isInvitee", "inviteeInfo", "access"]

    @field_validator('role')
    def role_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['user', '']):
            raise ValueError("must be one of enum values ('user', '')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetUsersResponseUsersInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of invitee_info
        if self.invitee_info:
            _dict['inviteeInfo'] = self.invitee_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in access (list)
        _items = []
        if self.access:
            for _item_access in self.access:
                if _item_access:
                    _items.append(_item_access.to_dict())
            _dict['access'] = _items
        # set to None if invitee_info (nullable) is None
        # and model_fields_set contains the field
        if self.invitee_info is None and "invitee_info" in self.model_fields_set:
            _dict['inviteeInfo'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetUsersResponseUsersInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "role": obj.get("role"),
            "position": obj.get("position"),
            "phone": obj.get("phone"),
            "email": obj.get("email"),
            "isOwner": obj.get("isOwner"),
            "firstName": obj.get("firstName"),
            "secondName": obj.get("secondName"),
            "patronymic": obj.get("patronymic"),
            "goodsReturn": obj.get("goodsReturn"),
            "isInvitee": obj.get("isInvitee"),
            "inviteeInfo": GetUsersResponseUsersInnerInviteeInfo.from_dict(obj["inviteeInfo"]) if obj.get("inviteeInfo") is not None else None,
            "access": [AccessInner.from_dict(_item) for _item in obj["access"]] if obj.get("access") is not None else None
        })
        return _obj


