# coding: utf-8

"""
    Общее

    В этом разделе:   - [общая информация о WB API](/openapi/api-information#tag/Vvedenie)   - как [начать работу с WB API](/openapi/api-information#tag/Vvedenie/Kak-nachat-rabotu-s-API)   - как [авторизоваться](/openapi/api-information#tag/Avtorizaciya) и [создавать токены](/openapi/api-information#tag/Avtorizaciya/Kak-sozdat-personalnyj-bazovyj-ili-testovyj-token)   - основные [статус-коды ответов](/openapi/api-information#tag/Vvedenie/Status-kody-HTTP)   - [лимиты запросов](/openapi/api-information#tag/Vvedenie/Limity-zaprosov)   - как обратиться в [поддержку](/openapi/api-information#tag/Vvedenie/Podderzhka)  С помощью методов этого раздела вы можете:   - проверить [подключение к WB API](/openapi/api-information#tag/Proverka-podklyucheniya-k-WB-API/paths/~1ping/get)   - получить [новости портала продавцов](/openapi/api-information#tag/API-novostej/paths/~1api~1communications~1v2~1news/get)   - получить [информацию о продавце](/openapi/api-information#tag/Informaciya-o-prodavce/paths/~1api~1v1~1seller-info/get)   - [управлять пользователями продавца](/openapi/api-information#tag/Upravlenie-polzovatelyami-prodavca) 

    The version of the OpenAPI document: general
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from wildberries_sdk.general.models.access_inner import AccessInner
from typing import Optional, Set
from typing_extensions import Self

class UserAccess(BaseModel):
    """
    UserAccess
    """ # noqa: E501
    user_id: Optional[StrictInt] = Field(default=None, description="ID пользователя", alias="userId")
    access: Optional[List[AccessInner]] = Field(default=None, description="Настройки доступа к разделам профиля продавца")
    __properties: ClassVar[List[str]] = ["userId", "access"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UserAccess from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in access (list)
        _items = []
        if self.access:
            for _item_access in self.access:
                if _item_access:
                    _items.append(_item_access.to_dict())
            _dict['access'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UserAccess from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "userId": obj.get("userId"),
            "access": [AccessInner.from_dict(_item) for _item in obj["access"]] if obj.get("access") is not None else None
        })
        return _obj


