# coding: utf-8

"""
    Заказы Самовывоз

    Управление [сборочными заданиями](/openapi/in-store-pickup#tag/Sborochnye-zadaniya-Samovyvoz) и [метаданными](/openapi/in-store-pickup#tag/Metadannye-Samovyvoz) заказов модели Самовывоз. 

    The version of the OpenAPI document: instorepickup
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class ApiNewOrder(BaseModel):
    """
    ApiNewOrder
    """ # noqa: E501
    ddate: Optional[StrictStr] = Field(default=None, description="Планируемая дата доставки")
    sale_price: Optional[StrictInt] = Field(default=None, description="Цена продавца в валюте продажи с учётом скидки продавца, без учёта скидки WB Клуба, умноженная на 100. Предоставляется в информационных целях ", alias="salePrice")
    required_meta: Optional[List[StrictStr]] = Field(default=None, description="Список метаданных, доступных для сборочного задания ", alias="requiredMeta")
    article: Optional[StrictStr] = Field(default=None, description="Артикул продавца")
    rid: Optional[StrictStr] = Field(default=None, description="Уникальный ID заказа. <br> Примечание: поле `rid` — это поле `srid` в ответах методов:   - [Заявки покупателей на возврат](./user-communication#tag/Vozvraty-pokupatelyami/paths/~1api~1v1~1claims/get)   - [Заказы](./reports#tag/Osnovnye-otchyoty/paths/~1api~1v1~1supplier~1orders/get)   - [Продажи](./reports#tag/Osnovnye-otchyoty/paths/~1api~1v1~1supplier~1sales/get)   - [Отчет о возвратах и перемещении товаров](./reports#tag/Otchyot-o-vozvratah-i-peremeshenii-tovarov)   - [Отчет о продажах по реализации](./financial-reports-and-accounting#tag/Finansovye-otchyoty/paths/~1api~1v5~1supplier~1reportDetailByPeriod/get) ")
    created_at: Optional[datetime] = Field(default=None, description="Дата и время создания сборочного задания", alias="createdAt")
    warehouse_address: Optional[StrictStr] = Field(default=None, description="Адрес магазина (склада продавца), на который поступило сборочное задание ", alias="warehouseAddress")
    order_code: Optional[StrictStr] = Field(default=None, description="Уникальный ID заказа покупателя ", alias="orderCode")
    pay_mode: Optional[StrictStr] = Field(default=None, description="Режим оплаты:   - `prepaid` — предоплатный   - `postpaid` — постоплатный   - `unknown` — неизвестный ", alias="payMode")
    skus: Optional[List[StrictStr]] = Field(default=None, description="Массив баркодов товара")
    id: Optional[StrictInt] = Field(default=None, description="ID сборочного задания")
    warehouse_id: Optional[StrictInt] = Field(default=None, description="ID склада продавца, на который поступило сборочное задание ", alias="warehouseId")
    nm_id: Optional[StrictInt] = Field(default=None, description="Артикул WB", alias="nmId")
    chrt_id: Optional[StrictInt] = Field(default=None, description="ID размера товара в системе WB", alias="chrtId")
    price: Optional[StrictInt] = Field(default=None, description="Цена в валюте продажи с учетом всех скидок, кроме скидки по WB Кошельку, умноженная на 100. Код валюты продажи указан в поле `currencyCode`. Предоставляется в информационных целях ")
    final_price: Optional[StrictInt] = Field(default=None, description="Сумма к оплате покупателем в валюте продажи с учетом всех скидок, умноженная на 100. Код валюты продажи указан в поле `currencyCode`. Предоставляется в информационных целях", alias="finalPrice")
    converted_price: Optional[StrictInt] = Field(default=None, description="Цена в валюте страны продавца с учетом всех скидок, кроме скидки по WB Кошельку, умноженная на 100. Код валюты продажи указан в поле `currencyCode`. Предоставляется в информационных целях", alias="convertedPrice")
    converted_final_price: Optional[StrictInt] = Field(default=None, description="Сумма к оплате покупателем в валюте страны продавца с учетом всех скидок, умноженная на 100. Предоставляется в информационных целях", alias="convertedFinalPrice")
    currency_code: Optional[StrictInt] = Field(default=None, description="Код валюты продажи", alias="currencyCode")
    converted_currency_code: Optional[StrictInt] = Field(default=None, description="Код валюты страны продавца", alias="convertedCurrencyCode")
    cargo_type: Optional[StrictInt] = Field(default=None, description="Тип товара:   - `1` — малогабаритный товар (МГТ)   - `2` — сверхгабаритный товар (СГТ)   - `3` — крупногабаритный товар (КГТ+) ", alias="cargoType")
    is_zero_order: Optional[StrictBool] = Field(default=None, description="Признак заказа товара с нулевым остатком:   - `false` — заказ сделан на товар с ненулевым остатком   - `true` — заказ сделан на товар с нулевым остатком. Такой заказ можно отменить без штрафа за отмену ", alias="isZeroOrder")
    __properties: ClassVar[List[str]] = ["ddate", "salePrice", "requiredMeta", "article", "rid", "createdAt", "warehouseAddress", "orderCode", "payMode", "skus", "id", "warehouseId", "nmId", "chrtId", "price", "finalPrice", "convertedPrice", "convertedFinalPrice", "currencyCode", "convertedCurrencyCode", "cargoType", "isZeroOrder"]

    @field_validator('cargo_type')
    def cargo_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set([1, 2, 3]):
            raise ValueError("must be one of enum values (1, 2, 3)")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ApiNewOrder from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if sale_price (nullable) is None
        # and model_fields_set contains the field
        if self.sale_price is None and "sale_price" in self.model_fields_set:
            _dict['salePrice'] = None

        # set to None if required_meta (nullable) is None
        # and model_fields_set contains the field
        if self.required_meta is None and "required_meta" in self.model_fields_set:
            _dict['requiredMeta'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ApiNewOrder from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "ddate": obj.get("ddate"),
            "salePrice": obj.get("salePrice"),
            "requiredMeta": obj.get("requiredMeta"),
            "article": obj.get("article"),
            "rid": obj.get("rid"),
            "createdAt": obj.get("createdAt"),
            "warehouseAddress": obj.get("warehouseAddress"),
            "orderCode": obj.get("orderCode"),
            "payMode": obj.get("payMode"),
            "skus": obj.get("skus"),
            "id": obj.get("id"),
            "warehouseId": obj.get("warehouseId"),
            "nmId": obj.get("nmId"),
            "chrtId": obj.get("chrtId"),
            "price": obj.get("price"),
            "finalPrice": obj.get("finalPrice"),
            "convertedPrice": obj.get("convertedPrice"),
            "convertedFinalPrice": obj.get("convertedFinalPrice"),
            "currencyCode": obj.get("currencyCode"),
            "convertedCurrencyCode": obj.get("convertedCurrencyCode"),
            "cargoType": obj.get("cargoType"),
            "isZeroOrder": obj.get("isZeroOrder")
        })
        return _obj


