# coding: utf-8

"""
    Заказы DBS

    <div class=\"description_important\">     Узнать больше о заказах DBS можно в <a href=\"https://seller.wildberries.ru/instructions/category/6572e024-7428-4db1-86a8-a4c7dbebbfcf?goBackOption=prevRoute&categoryId=5a8e1202-0865-45b7-acae-5d0afc7add56\">справочном центре</a> </div>  Управление [сборочными заданиями](/openapi/orders-dbs#tag/Sborochnye-zadaniya-DBS) и [метаданными](/openapi/orders-dbs#tag/Metadannye-DBS) заказов DBS (Delivery by Seller). 

    The version of the OpenAPI document: order
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from wildberries_sdk.orders_dbs.models.order_dbs_address import OrderDBSAddress
from wildberries_sdk.orders_dbs.models.order_new_dbs_options import OrderNewDBSOptions
from typing import Optional, Set
from typing_extensions import Self

class OrderDBS(BaseModel):
    """
    OrderDBS
    """ # noqa: E501
    address: Optional[OrderDBSAddress] = None
    delivery_type: Optional[StrictStr] = Field(default=None, description="Тип доставки:   - `dbs` — доставка силами продавца   - `edbs` — экспресс-доставка силами продавца ", alias="deliveryType")
    options: Optional[OrderNewDBSOptions] = None
    order_uid: Optional[StrictStr] = Field(default=None, description="ID транзакции для группировки сборочных заданий. Сборочные задания в одной корзине покупателя будут иметь одинаковый `orderUID`", alias="orderUid")
    group_id: Optional[StrictStr] = Field(default=None, description="ID группы сборочных заданий. <br> Объединяет сборочные задания, поступившие на один склад (`warehouseId`) в рамках одной транзакции покупателя (`orderUid`)", alias="groupId")
    article: Optional[StrictStr] = Field(default=None, description="Артикул продавца")
    color_code: Optional[StrictStr] = Field(default=None, description="Код цвета (только для колеруемых товаров)", alias="colorCode")
    rid: Optional[StrictStr] = Field(default=None, description="Уникальный ID заказа. <br> Примечание: `rid` — это `srid` в ответах методов:   - [Заявки покупателей на возврат](./user-communication#tag/Vozvraty-pokupatelyami/paths/~1api~1v1~1claims/get)   - [Заказы](./reports#tag/Osnovnye-otchyoty/paths/~1api~1v1~1supplier~1orders/get)   - [Продажи](./reports#tag/Osnovnye-otchyoty/paths/~1api~1v1~1supplier~1sales/get)   - [Отчет о возвратах и перемещении товаров](./reports#tag/Otchyot-o-vozvratah-i-peremeshenii-tovarov)   - [Отчет о продажах по реализации](./financial-reports-and-accounting#tag/Finansovye-otchyoty/paths/~1api~1v5~1supplier~1reportDetailByPeriod/get) ")
    created_at: Optional[datetime] = Field(default=None, description="Дата создания сборочного задания", alias="createdAt")
    skus: Optional[List[StrictStr]] = Field(default=None, description="Массив баркодов товара")
    id: Optional[StrictInt] = Field(default=None, description="ID сборочного задания")
    warehouse_id: Optional[StrictInt] = Field(default=None, description="ID склада продавца, на который поступило сборочное задание", alias="warehouseId")
    nm_id: Optional[StrictInt] = Field(default=None, description="Артикул WB", alias="nmId")
    chrt_id: Optional[StrictInt] = Field(default=None, description="ID размера товара в системе WB", alias="chrtId")
    price: Optional[StrictInt] = Field(default=None, description="Цена в валюте продажи с учетом всех скидок, кроме скидки по WB Кошельку, умноженная на 100. Код валюты продажи указан в поле `currencyCode`. Предоставляется в информационных целях")
    converted_price: Optional[StrictInt] = Field(default=None, description="Цена в валюте страны продавца с учетом всех скидок, кроме скидки по WB Кошельку, умноженная на 100. Предоставляется в информационных целях", alias="convertedPrice")
    currency_code: Optional[StrictInt] = Field(default=None, description="Код валюты продажи", alias="currencyCode")
    converted_currency_code: Optional[StrictInt] = Field(default=None, description="Код валюты страны продавца", alias="convertedCurrencyCode")
    converted_final_price: Optional[StrictInt] = Field(default=None, description="Сумма к оплате покупателем в валюте страны продавца с учетом всех скидок, умноженная на 100. Предоставляется в информационных целях", alias="convertedFinalPrice")
    final_price: Optional[StrictInt] = Field(default=None, description="Сумма к оплате покупателем в валюте продажи с учетом всех скидок, умноженная на 100. Код валюты продажи указан в поле `currencyCode`. Предоставляется в информационных целях", alias="finalPrice")
    cargo_type: Optional[StrictInt] = Field(default=None, description="Тип товара:   - `1` — малогабаритный товар (МГТ)   - `2` — сверхгабаритный товар (СГТ)   - `3` — крупногабаритный товар (КГТ+) ", alias="cargoType")
    comment: Optional[Annotated[str, Field(strict=True, max_length=300)]] = Field(default=None, description="Комментарий покупателя")
    is_zero_order: Optional[StrictBool] = Field(default=None, description="Признак заказа товара с нулевым остатком:   - `false` — заказ сделан на товар с ненулевым остатком   - `true` — заказ сделан на товар с нулевым остатком. Такой заказ можно отменить без штрафа за отмену ", alias="isZeroOrder")
    __properties: ClassVar[List[str]] = ["address", "deliveryType", "options", "orderUid", "groupId", "article", "colorCode", "rid", "createdAt", "skus", "id", "warehouseId", "nmId", "chrtId", "price", "convertedPrice", "currencyCode", "convertedCurrencyCode", "convertedFinalPrice", "finalPrice", "cargoType", "comment", "isZeroOrder"]

    @field_validator('cargo_type')
    def cargo_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set([1, 2, 3]):
            raise ValueError("must be one of enum values (1, 2, 3)")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of OrderDBS from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of address
        if self.address:
            _dict['address'] = self.address.to_dict()
        # override the default output from pydantic by calling `to_dict()` of options
        if self.options:
            _dict['options'] = self.options.to_dict()
        # set to None if address (nullable) is None
        # and model_fields_set contains the field
        if self.address is None and "address" in self.model_fields_set:
            _dict['address'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of OrderDBS from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "address": OrderDBSAddress.from_dict(obj["address"]) if obj.get("address") is not None else None,
            "deliveryType": obj.get("deliveryType"),
            "options": OrderNewDBSOptions.from_dict(obj["options"]) if obj.get("options") is not None else None,
            "orderUid": obj.get("orderUid"),
            "groupId": obj.get("groupId"),
            "article": obj.get("article"),
            "colorCode": obj.get("colorCode"),
            "rid": obj.get("rid"),
            "createdAt": obj.get("createdAt"),
            "skus": obj.get("skus"),
            "id": obj.get("id"),
            "warehouseId": obj.get("warehouseId"),
            "nmId": obj.get("nmId"),
            "chrtId": obj.get("chrtId"),
            "price": obj.get("price"),
            "convertedPrice": obj.get("convertedPrice"),
            "currencyCode": obj.get("currencyCode"),
            "convertedCurrencyCode": obj.get("convertedCurrencyCode"),
            "convertedFinalPrice": obj.get("convertedFinalPrice"),
            "finalPrice": obj.get("finalPrice"),
            "cargoType": obj.get("cargoType"),
            "comment": obj.get("comment"),
            "isZeroOrder": obj.get("isZeroOrder")
        })
        return _obj


