# coding: utf-8

"""
    Заказы DBS

    <div class=\"description_important\">     Узнать больше о заказах DBS можно в <a href=\"https://seller.wildberries.ru/instructions/category/6572e024-7428-4db1-86a8-a4c7dbebbfcf?goBackOption=prevRoute&categoryId=5a8e1202-0865-45b7-acae-5d0afc7add56\">справочном центре</a> </div>  Управление [сборочными заданиями](/openapi/orders-dbs#tag/Sborochnye-zadaniya-DBS) и [метаданными](/openapi/orders-dbs#tag/Metadannye-DBS) заказов DBS (Delivery by Seller). 

    The version of the OpenAPI document: order
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from wildberries_sdk.orders_dbs.models.order_new_dbs_address import OrderNewDBSAddress
from wildberries_sdk.orders_dbs.models.order_new_dbs_options import OrderNewDBSOptions
from typing import Optional, Set
from typing_extensions import Self

class OrderNewDBS(BaseModel):
    """
    OrderNewDBS
    """ # noqa: E501
    sale_price: Optional[StrictInt] = Field(default=None, description="Цена в валюте продажи с учетом скидки продавца, без учета скидки WB Клуба, умноженная на 100. Предоставляется в информационных целях ", alias="salePrice")
    required_meta: Optional[List[StrictStr]] = Field(default=None, description="Список метаданных, доступных для сборочного задания. [Указывать IMEI](./orders-dbs#tag/Metadannye-DBS/paths/~1api~1marketplace~1v3~1dbs~1orders~1meta~1imei/post) обязательно для [предмета](./work-with-products/#tag/Kategorii-predmety-i-harakteristiki/paths/~1content~1v2~1object~1all/get) `Смартфоны`, `\"subjectId\":515`", alias="requiredMeta")
    comment: Optional[Annotated[str, Field(strict=True, max_length=300)]] = Field(default=None, description="Комментарий покупателя")
    options: Optional[OrderNewDBSOptions] = None
    address: Optional[OrderNewDBSAddress] = None
    order_uid: Optional[StrictStr] = Field(default=None, description="ID транзакции для группировки сборочных заданий. Сборочные задания в одной корзине покупателя будут иметь одинаковый `orderUID`", alias="orderUid")
    group_id: Optional[StrictStr] = Field(default=None, description="ID группы сборочных заданий. <br> Объединяет сборочные задания, поступившие на один склад (`warehouseId`) в рамках одной транзакции покупателя (`orderUid`)", alias="groupId")
    article: Optional[StrictStr] = Field(default=None, description="Артикул продавца")
    color_code: Optional[StrictStr] = Field(default=None, description="Код цвета (только для колеруемых товаров)", alias="colorCode")
    rid: Optional[StrictStr] = Field(default=None, description="Уникальный ID заказа. <br> Примечание: `rid` — это `srid` в ответах методов:   - [Заявки покупателей на возврат](./user-communication#tag/Vozvraty-pokupatelyami/paths/~1api~1v1~1claims/get)   - [Заказы](./reports#tag/Osnovnye-otchyoty/paths/~1api~1v1~1supplier~1orders/get)   - [Продажи](./reports#tag/Osnovnye-otchyoty/paths/~1api~1v1~1supplier~1sales/get)   - [Отчет о возвратах и перемещении товаров](./reports#tag/Otchyot-o-vozvratah-i-peremeshenii-tovarov)   - [Отчет о продажах по реализации](./financial-reports-and-accounting#tag/Finansovye-otchyoty/paths/~1api~1v5~1supplier~1reportDetailByPeriod/get) ")
    created_at: Optional[datetime] = Field(default=None, description="Дата создания сборочного задания", alias="createdAt")
    delivery_type: Optional[StrictStr] = Field(default=None, description="Тип доставки:   - `dbs` — доставка силами продавца   - `edbs` — экспресс-доставка силами продавца ", alias="deliveryType")
    skus: Optional[List[StrictStr]] = Field(default=None, description="Массив баркодов товара")
    id: Optional[StrictInt] = Field(default=None, description="ID сборочного задания")
    warehouse_id: Optional[StrictInt] = Field(default=None, description="ID склада продавца, на который поступило сборочное задание", alias="warehouseId")
    nm_id: Optional[StrictInt] = Field(default=None, description="Артикул WB", alias="nmId")
    chrt_id: Optional[StrictInt] = Field(default=None, description="ID размера товара в системе WB", alias="chrtId")
    price: Optional[StrictInt] = Field(default=None, description="Цена в валюте продажи с учетом всех скидок, кроме скидки по WB Кошельку, умноженная на 100. Код валюты продажи указан в поле `currencyCode`. Предоставляется в информационных целях")
    final_price: Optional[StrictInt] = Field(default=None, description="Сумма к оплате покупателем в валюте продажи с учетом всех скидок, умноженная на 100. Код валюты продажи указан в поле `currencyCode`. Предоставляется в информационных целях", alias="finalPrice")
    converted_final_price: Optional[StrictInt] = Field(default=None, description="Сумма к оплате покупателем в валюте страны продавца с учетом всех скидок, умноженная на 100. Предоставляется в информационных целях", alias="convertedFinalPrice")
    converted_price: Optional[StrictInt] = Field(default=None, description="Цена в валюте страны продавца с учетом всех скидок, кроме скидки по WB Кошельку, умноженная на 100. Предоставляется в информационных целях", alias="convertedPrice")
    currency_code: Optional[StrictInt] = Field(default=None, description="Код валюты продажи", alias="currencyCode")
    converted_currency_code: Optional[StrictInt] = Field(default=None, description="Код валюты страны продавца", alias="convertedCurrencyCode")
    cargo_type: Optional[StrictInt] = Field(default=None, description="Тип товара:   - `1` — малогабаритный товар (МГТ)   - `2` — сверхгабаритный товар (СГТ)   - `3` — крупногабаритный товар (КГТ+) ", alias="cargoType")
    is_zero_order: Optional[StrictBool] = Field(default=None, description="Признак заказа товара с нулевым остатком:   - `false` — заказ сделан на товар с ненулевым остатком   - `true` — заказ сделан на товар с нулевым остатком. Такой заказ можно отменить без штрафа за отмену ", alias="isZeroOrder")
    __properties: ClassVar[List[str]] = ["salePrice", "requiredMeta", "comment", "options", "address", "orderUid", "groupId", "article", "colorCode", "rid", "createdAt", "deliveryType", "skus", "id", "warehouseId", "nmId", "chrtId", "price", "finalPrice", "convertedFinalPrice", "convertedPrice", "currencyCode", "convertedCurrencyCode", "cargoType", "isZeroOrder"]

    @field_validator('delivery_type')
    def delivery_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['dbs', 'edbs']):
            raise ValueError("must be one of enum values ('dbs', 'edbs')")
        return value

    @field_validator('cargo_type')
    def cargo_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set([1, 2, 3]):
            raise ValueError("must be one of enum values (1, 2, 3)")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of OrderNewDBS from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of options
        if self.options:
            _dict['options'] = self.options.to_dict()
        # override the default output from pydantic by calling `to_dict()` of address
        if self.address:
            _dict['address'] = self.address.to_dict()
        # set to None if sale_price (nullable) is None
        # and model_fields_set contains the field
        if self.sale_price is None and "sale_price" in self.model_fields_set:
            _dict['salePrice'] = None

        # set to None if required_meta (nullable) is None
        # and model_fields_set contains the field
        if self.required_meta is None and "required_meta" in self.model_fields_set:
            _dict['requiredMeta'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of OrderNewDBS from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "salePrice": obj.get("salePrice"),
            "requiredMeta": obj.get("requiredMeta"),
            "comment": obj.get("comment"),
            "options": OrderNewDBSOptions.from_dict(obj["options"]) if obj.get("options") is not None else None,
            "address": OrderNewDBSAddress.from_dict(obj["address"]) if obj.get("address") is not None else None,
            "orderUid": obj.get("orderUid"),
            "groupId": obj.get("groupId"),
            "article": obj.get("article"),
            "colorCode": obj.get("colorCode"),
            "rid": obj.get("rid"),
            "createdAt": obj.get("createdAt"),
            "deliveryType": obj.get("deliveryType"),
            "skus": obj.get("skus"),
            "id": obj.get("id"),
            "warehouseId": obj.get("warehouseId"),
            "nmId": obj.get("nmId"),
            "chrtId": obj.get("chrtId"),
            "price": obj.get("price"),
            "finalPrice": obj.get("finalPrice"),
            "convertedFinalPrice": obj.get("convertedFinalPrice"),
            "convertedPrice": obj.get("convertedPrice"),
            "currencyCode": obj.get("currencyCode"),
            "convertedCurrencyCode": obj.get("convertedCurrencyCode"),
            "cargoType": obj.get("cargoType"),
            "isZeroOrder": obj.get("isZeroOrder")
        })
        return _obj


