# coding: utf-8

"""
    Заказы DBW

    Управление [сборочными заданиями](/openapi/orders-dbw#tag/Sborochnye-zadaniya-DBW) и [метаданными](/openapi/orders-dbw#tag/Metadannye-DBW) заказов DBW (Доставка курьером WB).

    The version of the OpenAPI document: ordersdbw
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool
from typing import Any, ClassVar, Dict, List, Optional
from wildberries_sdk.orders_dbw.models.courier_contacts_response import CourierContactsResponse
from typing import Optional, Set
from typing_extensions import Self

class CourierInfo(BaseModel):
    """
    CourierInfo
    """ # noqa: E501
    contacts: Optional[CourierContactsResponse] = Field(default=None, description="Контактные данные курьера")
    must_be_assigned: Optional[StrictBool] = Field(default=None, description="Должен ли быть назначен курьер к текущему моменту:   - `false` — нет   - `true` — да     Если `\"mustBeAssigned\":true`, а `\"contacts\":null`, необходимо запросить контакты в [поддержке](https://seller.wildberries.ru/service-desk-v2) ", alias="mustBeAssigned")
    p_time_from: Optional[datetime] = Field(default=None, description="Дата и время, с которого прибудет курьер", alias="pTimeFrom")
    p_time_to: Optional[datetime] = Field(default=None, description="Дата и время, до которого прибудет курьер", alias="pTimeTo")
    updated_at: Optional[datetime] = Field(default=None, description="Дата и время обновления информации о курьере. <br> Если `null`, информация не обновлялась", alias="updatedAt")
    __properties: ClassVar[List[str]] = ["contacts", "mustBeAssigned", "pTimeFrom", "pTimeTo", "updatedAt"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CourierInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of contacts
        if self.contacts:
            _dict['contacts'] = self.contacts.to_dict()
        # set to None if contacts (nullable) is None
        # and model_fields_set contains the field
        if self.contacts is None and "contacts" in self.model_fields_set:
            _dict['contacts'] = None

        # set to None if p_time_from (nullable) is None
        # and model_fields_set contains the field
        if self.p_time_from is None and "p_time_from" in self.model_fields_set:
            _dict['pTimeFrom'] = None

        # set to None if p_time_to (nullable) is None
        # and model_fields_set contains the field
        if self.p_time_to is None and "p_time_to" in self.model_fields_set:
            _dict['pTimeTo'] = None

        # set to None if updated_at (nullable) is None
        # and model_fields_set contains the field
        if self.updated_at is None and "updated_at" in self.model_fields_set:
            _dict['updatedAt'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CourierInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "contacts": CourierContactsResponse.from_dict(obj["contacts"]) if obj.get("contacts") is not None else None,
            "mustBeAssigned": obj.get("mustBeAssigned"),
            "pTimeFrom": obj.get("pTimeFrom"),
            "pTimeTo": obj.get("pTimeTo"),
            "updatedAt": obj.get("updatedAt")
        })
        return _obj


