# coding: utf-8

"""
    Заказы FBS

    <div class=\"description_important\"> <b>Методы для работы со сборочными заданиями модели DBW (Доставка курьером WB) теперь на <a href=\"https://dev.wildberries.ru/release-notes?id=312\">отдельном контуре</a>.</b> </div>   В разделе заказов FBS (Fulfillment by Seller) вам доступны методы:   1. Управления [сборочными заданиями](/openapi/orders-fbs#tag/Sborochnye-zadaniya): информация о сборочных заданиях, метаданные, стикеры и так далее.   2. Управления [поставками заказов](/openapi/orders-fbs#tag/Postavki-FBS) продавца на склады WB.   3. Заказа [пропусков](/openapi/orders-fbs#tag/Propuska-FBS) на склады WB. <br> <div class=\"description_important\">     Узнать больше о заказах FBS можно в <a href=\"https://seller.wildberries.ru/instructions/ru/ru/category/b3e60238-fd4c-49ce-8668-ff688725a12d\">справочном центре</a> </div> 

    The version of the OpenAPI document: order
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from wildberries_sdk.orders_fbs.models.order_address import OrderAddress
from wildberries_sdk.orders_fbs.models.order_options import OrderOptions
from typing import Optional, Set
from typing_extensions import Self

class OrderNew(BaseModel):
    """
    OrderNew
    """ # noqa: E501
    address: Optional[OrderAddress] = None
    ddate: Optional[StrictStr] = Field(default=None, description="Планируемая дата доставки.<br> Поле отображается для сборочных заданий со сверхгабаритными товарами `СГТ`, `cargoType: 2` ")
    seller_date: Optional[StrictStr] = Field(default=None, description="Рекомендуемая дата доставки СГТ в сортировочный центр или на склад. <br> Поле отображается для сборочных заданий со сверхгабаритными товарами `СГТ`, `cargoType: 2` ", alias="sellerDate")
    sale_price: Optional[StrictInt] = Field(default=None, description="Цена продавца в валюте продажи с учётом скидки продавца, без учёта скидки WB Клуба, умноженная на 100. Предоставляется в информационных целях ", alias="salePrice")
    required_meta: Optional[List[StrictStr]] = Field(default=None, description="Список метаданных, которые необходимо добавить в сборочное задание, чтобы поставку с этим сборочным заданием можно было перевести в доставку ", alias="requiredMeta")
    optional_meta: Optional[List[StrictStr]] = Field(default=None, description="Список метаданных, которые можно добавить в сборочное задание.<br> Поставку со сборочным заданием без этих метаданных можно перевести в доставку, но они могут потребоваться, например, при возврате товара покупателем ", alias="optionalMeta")
    delivery_type: Optional[StrictStr] = Field(default=None, description="Тип доставки: - `fbs` — доставка на склад Wildberries (FBS) ", alias="deliveryType")
    comment: Optional[Annotated[str, Field(strict=True, max_length=300)]] = Field(default=None, description="Комментарий покупателя")
    scan_price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Цена приёмки в копейках. Отображается после фактической приёмки заказа. Для данного метода всегда будет возвращаться `null`. Предоставляется в информационных целях", alias="scanPrice")
    order_uid: Optional[StrictStr] = Field(default=None, description="ID транзакции для группировки сборочных заданий. Сборочные задания в одной корзине покупателя будут иметь одинаковый `orderUid`", alias="orderUid")
    article: Optional[StrictStr] = Field(default=None, description="Артикул продавца")
    color_code: Optional[StrictStr] = Field(default=None, description="Код цвета (только для колеруемых товаров)", alias="colorCode")
    rid: Optional[StrictStr] = Field(default=None, description="Уникальный ID заказа. <br> Примечание: `rid` — это `srid` в ответах методов:   - [Заявки покупателей на возврат](./user-communication#tag/Vozvraty-pokupatelyami/paths/~1api~1v1~1claims/get)   - [Заказы](./reports#tag/Osnovnye-otchyoty/paths/~1api~1v1~1supplier~1orders/get)   - [Продажи](./reports#tag/Osnovnye-otchyoty/paths/~1api~1v1~1supplier~1sales/get)   - [Отчет о возвратах и перемещении товаров](./reports#tag/Otchyot-o-vozvratah-i-peremeshenii-tovarov)   - [Отчет о продажах по реализации](./financial-reports-and-accounting#tag/Finansovye-otchyoty/paths/~1api~1v5~1supplier~1reportDetailByPeriod/get) ")
    created_at: Optional[datetime] = Field(default=None, description="Дата создания сборочного задания (RFC3339)", alias="createdAt")
    offices: Optional[List[StrictStr]] = Field(default=None, description="Список офисов, куда следует привезти товар")
    skus: Optional[List[StrictStr]] = Field(default=None, description="Список баркодов")
    id: Optional[StrictInt] = Field(default=None, description="ID сборочного задания")
    warehouse_id: Optional[StrictInt] = Field(default=None, description="ID склада продавца, на который поступило сборочное задание", alias="warehouseId")
    office_id: Optional[StrictInt] = Field(default=None, description="ID склада WB, к которому привязан склад продавца", alias="officeId")
    nm_id: Optional[StrictInt] = Field(default=None, description="Артикул WB", alias="nmId")
    chrt_id: Optional[StrictInt] = Field(default=None, description="ID размера товара в системе WB", alias="chrtId")
    price: Optional[StrictInt] = Field(default=None, description="Цена в валюте продажи с учётом всех скидок, кроме скидки по WB Кошельку, умноженная на 100. Код валюты продажи — в поле `currencyCode`. Предоставляется в информационных целях ")
    final_price: Optional[StrictInt] = Field(default=None, description="Сумма к оплате покупателем в валюте продажи с учетом всех скидок, умноженная на 100. Код валюты продажи указан в поле `currencyCode`. Предоставляется в информационных целях", alias="finalPrice")
    converted_price: Optional[StrictInt] = Field(default=None, description="Цена в валюте страны продавца с учетом всех скидок, кроме скидки по WB Кошельку, умноженная на 100. Предоставляется в информационных целях", alias="convertedPrice")
    converted_final_price: Optional[StrictInt] = Field(default=None, description="Сумма к оплате покупателем в валюте страны продавца с учетом всех скидок, умноженная на 100. Предоставляется в информационных целях", alias="convertedFinalPrice")
    currency_code: Optional[StrictInt] = Field(default=None, description="Код валюты продажи", alias="currencyCode")
    converted_currency_code: Optional[StrictInt] = Field(default=None, description="Код валюты страны продавца", alias="convertedCurrencyCode")
    cargo_type: Optional[StrictInt] = Field(default=None, description="Тип товара:   - `1` — малогабаритный товар (МГТ)   - `2` — сверхгабаритный товар (СГТ)   - `3` — крупногабаритный товар (КГТ+) ", alias="cargoType")
    is_zero_order: Optional[StrictBool] = Field(default=None, description="Признак заказа товара с нулевым остатком:   - `false` — заказ сделан на товар с ненулевым остатком   - `true` — заказ сделан на товар с нулевым остатком. Такой заказ можно отменить без штрафа за отмену ", alias="isZeroOrder")
    options: Optional[OrderOptions] = None
    __properties: ClassVar[List[str]] = ["address", "ddate", "sellerDate", "salePrice", "requiredMeta", "optionalMeta", "deliveryType", "comment", "scanPrice", "orderUid", "article", "colorCode", "rid", "createdAt", "offices", "skus", "id", "warehouseId", "officeId", "nmId", "chrtId", "price", "finalPrice", "convertedPrice", "convertedFinalPrice", "currencyCode", "convertedCurrencyCode", "cargoType", "isZeroOrder", "options"]

    @field_validator('delivery_type')
    def delivery_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['fbs']):
            raise ValueError("must be one of enum values ('fbs')")
        return value

    @field_validator('cargo_type')
    def cargo_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set([1, 2, 3]):
            raise ValueError("must be one of enum values (1, 2, 3)")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of OrderNew from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of address
        if self.address:
            _dict['address'] = self.address.to_dict()
        # override the default output from pydantic by calling `to_dict()` of options
        if self.options:
            _dict['options'] = self.options.to_dict()
        # set to None if address (nullable) is None
        # and model_fields_set contains the field
        if self.address is None and "address" in self.model_fields_set:
            _dict['address'] = None

        # set to None if seller_date (nullable) is None
        # and model_fields_set contains the field
        if self.seller_date is None and "seller_date" in self.model_fields_set:
            _dict['sellerDate'] = None

        # set to None if sale_price (nullable) is None
        # and model_fields_set contains the field
        if self.sale_price is None and "sale_price" in self.model_fields_set:
            _dict['salePrice'] = None

        # set to None if required_meta (nullable) is None
        # and model_fields_set contains the field
        if self.required_meta is None and "required_meta" in self.model_fields_set:
            _dict['requiredMeta'] = None

        # set to None if optional_meta (nullable) is None
        # and model_fields_set contains the field
        if self.optional_meta is None and "optional_meta" in self.model_fields_set:
            _dict['optionalMeta'] = None

        # set to None if scan_price (nullable) is None
        # and model_fields_set contains the field
        if self.scan_price is None and "scan_price" in self.model_fields_set:
            _dict['scanPrice'] = None

        # set to None if offices (nullable) is None
        # and model_fields_set contains the field
        if self.offices is None and "offices" in self.model_fields_set:
            _dict['offices'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of OrderNew from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "address": OrderAddress.from_dict(obj["address"]) if obj.get("address") is not None else None,
            "ddate": obj.get("ddate"),
            "sellerDate": obj.get("sellerDate"),
            "salePrice": obj.get("salePrice"),
            "requiredMeta": obj.get("requiredMeta"),
            "optionalMeta": obj.get("optionalMeta"),
            "deliveryType": obj.get("deliveryType"),
            "comment": obj.get("comment"),
            "scanPrice": obj.get("scanPrice"),
            "orderUid": obj.get("orderUid"),
            "article": obj.get("article"),
            "colorCode": obj.get("colorCode"),
            "rid": obj.get("rid"),
            "createdAt": obj.get("createdAt"),
            "offices": obj.get("offices"),
            "skus": obj.get("skus"),
            "id": obj.get("id"),
            "warehouseId": obj.get("warehouseId"),
            "officeId": obj.get("officeId"),
            "nmId": obj.get("nmId"),
            "chrtId": obj.get("chrtId"),
            "price": obj.get("price"),
            "finalPrice": obj.get("finalPrice"),
            "convertedPrice": obj.get("convertedPrice"),
            "convertedFinalPrice": obj.get("convertedFinalPrice"),
            "currencyCode": obj.get("currencyCode"),
            "convertedCurrencyCode": obj.get("convertedCurrencyCode"),
            "cargoType": obj.get("cargoType"),
            "isZeroOrder": obj.get("isZeroOrder"),
            "options": OrderOptions.from_dict(obj["options"]) if obj.get("options") is not None else None
        })
        return _obj


