# coding: utf-8

"""
    Поставки FBW

    <div class=\"description_important\">     Узнать больше о поставках FBW можно в <a href=\"https://seller.wildberries.ru/instructions/subcategory/5a8e1202-0865-45b7-acae-5d0afc7add56?goBackOption=prevRoute&categoryId=479385c6-de01-4b4d-ad4e-ed941e65582e\">справочном центре</a> </div>  В разделе описаны методы получения:   - [информации для формирования поставок](/openapi/orders-fbw#tag/Informaciya-dlya-formirovaniya-postavok)   - [информации о поставках](/openapi/orders-fbw#tag/Informaciya-o-postavkah) 

    The version of the OpenAPI document: ordersfbw
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class ModelsGoodInSupply(BaseModel):
    """
    ModelsGoodInSupply
    """ # noqa: E501
    barcode: Optional[StrictStr] = Field(default=None, description="Баркод товара")
    vendor_code: Optional[StrictStr] = Field(default=None, description="Артикул продавца", alias="vendorCode")
    nm_id: Optional[StrictInt] = Field(default=None, description="Артикул WB", alias="nmID")
    need_kiz: Optional[StrictBool] = Field(default=None, description="Нужен ли [код маркировки](https://честныйзнак.рф/) для этого товара:   - `false` — не нужен   - `true` — нужен ", alias="needKiz")
    tnved: Optional[StrictStr] = Field(default=None, description="Код ТНВЭД. <br> Если `\"needKiz\":true`, а `\"tnved\":null`, нужно заполнить характеристику товара **ТН ВЭД** в [личном кабинете](https://seller.wildberries.ru/new-goods) или по [API](./work-with-products#tag/Kartochki-tovarov/paths/~1content~1v2~1cards~1update/post) ")
    tech_size: Optional[StrictStr] = Field(default=None, description="Размер товара, указанный продавцом", alias="techSize")
    color: Optional[StrictStr] = Field(default=None, description="Цвет товара")
    supplier_box_amount: Optional[StrictInt] = Field(default=None, description="Указано в упаковке, шт", alias="supplierBoxAmount")
    quantity: Optional[StrictInt] = Field(default=None, description="Указано в поставке/заказе, шт")
    ready_for_sale_quantity: Optional[StrictInt] = Field(default=None, description="Поступило в продажу, шт", alias="readyForSaleQuantity")
    accepted_quantity: Optional[StrictInt] = Field(default=None, description="Принято, шт", alias="acceptedQuantity")
    unloading_quantity: Optional[StrictInt] = Field(default=None, description="Количество товара на раскладке, шт", alias="unloadingQuantity")
    __properties: ClassVar[List[str]] = ["barcode", "vendorCode", "nmID", "needKiz", "tnved", "techSize", "color", "supplierBoxAmount", "quantity", "readyForSaleQuantity", "acceptedQuantity", "unloadingQuantity"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ModelsGoodInSupply from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if tnved (nullable) is None
        # and model_fields_set contains the field
        if self.tnved is None and "tnved" in self.model_fields_set:
            _dict['tnved'] = None

        # set to None if color (nullable) is None
        # and model_fields_set contains the field
        if self.color is None and "color" in self.model_fields_set:
            _dict['color'] = None

        # set to None if supplier_box_amount (nullable) is None
        # and model_fields_set contains the field
        if self.supplier_box_amount is None and "supplier_box_amount" in self.model_fields_set:
            _dict['supplierBoxAmount'] = None

        # set to None if ready_for_sale_quantity (nullable) is None
        # and model_fields_set contains the field
        if self.ready_for_sale_quantity is None and "ready_for_sale_quantity" in self.model_fields_set:
            _dict['readyForSaleQuantity'] = None

        # set to None if accepted_quantity (nullable) is None
        # and model_fields_set contains the field
        if self.accepted_quantity is None and "accepted_quantity" in self.model_fields_set:
            _dict['acceptedQuantity'] = None

        # set to None if unloading_quantity (nullable) is None
        # and model_fields_set contains the field
        if self.unloading_quantity is None and "unloading_quantity" in self.model_fields_set:
            _dict['unloadingQuantity'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ModelsGoodInSupply from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "barcode": obj.get("barcode"),
            "vendorCode": obj.get("vendorCode"),
            "nmID": obj.get("nmID"),
            "needKiz": obj.get("needKiz"),
            "tnved": obj.get("tnved"),
            "techSize": obj.get("techSize"),
            "color": obj.get("color"),
            "supplierBoxAmount": obj.get("supplierBoxAmount"),
            "quantity": obj.get("quantity"),
            "readyForSaleQuantity": obj.get("readyForSaleQuantity"),
            "acceptedQuantity": obj.get("acceptedQuantity"),
            "unloadingQuantity": obj.get("unloadingQuantity")
        })
        return _obj


