# coding: utf-8

"""
    Поставки FBW

    <div class=\"description_important\">     Узнать больше о поставках FBW можно в <a href=\"https://seller.wildberries.ru/instructions/subcategory/5a8e1202-0865-45b7-acae-5d0afc7add56?goBackOption=prevRoute&categoryId=479385c6-de01-4b4d-ad4e-ed941e65582e\">справочном центре</a> </div>  В разделе описаны методы получения:   - [информации для формирования поставок](/openapi/orders-fbw#tag/Informaciya-dlya-formirovaniya-postavok)   - [информации о поставках](/openapi/orders-fbw#tag/Informaciya-o-postavkah) 

    The version of the OpenAPI document: ordersfbw
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class ModelsSupply(BaseModel):
    """
    ModelsSupply
    """ # noqa: E501
    phone: Optional[StrictStr] = Field(default=None, description="Телефон пользователя, создавшего поставку")
    supply_id: Optional[StrictInt] = Field(default=None, description="ID поставки. Если `null`, это заказ, тогда используйте значение поля `preorderID`", alias="supplyID")
    preorder_id: Optional[StrictInt] = Field(default=None, description="ID заказа (незапланированная поставка). Для всех виртуальных поставок будет `0`", alias="preorderID")
    create_date: Optional[StrictStr] = Field(default=None, description="Дата и время создания поставки", alias="createDate")
    supply_date: Optional[StrictStr] = Field(default=None, description="Плановая дата отгрузки поставки", alias="supplyDate")
    fact_date: Optional[StrictStr] = Field(default=None, description="Дата фактической отгрузки поставки", alias="factDate")
    updated_date: Optional[StrictStr] = Field(default=None, description="Дата изменения поставки", alias="updatedDate")
    status_id: Optional[StrictInt] = Field(default=None, description="ID статуса поставки:   - `1` — Не запланировано   - `2` — Запланировано   - `3` — Отгрузка разрешена   - `4` — Идёт приёмка   - `5` — Принято   - `6` — Отгружено на воротах ", alias="statusID")
    __properties: ClassVar[List[str]] = ["phone", "supplyID", "preorderID", "createDate", "supplyDate", "factDate", "updatedDate", "statusID"]

    @field_validator('status_id')
    def status_id_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set([1, 2, 3, 4, 5, 6]):
            raise ValueError("must be one of enum values (1, 2, 3, 4, 5, 6)")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ModelsSupply from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if supply_id (nullable) is None
        # and model_fields_set contains the field
        if self.supply_id is None and "supply_id" in self.model_fields_set:
            _dict['supplyID'] = None

        # set to None if supply_date (nullable) is None
        # and model_fields_set contains the field
        if self.supply_date is None and "supply_date" in self.model_fields_set:
            _dict['supplyDate'] = None

        # set to None if fact_date (nullable) is None
        # and model_fields_set contains the field
        if self.fact_date is None and "fact_date" in self.model_fields_set:
            _dict['factDate'] = None

        # set to None if updated_date (nullable) is None
        # and model_fields_set contains the field
        if self.updated_date is None and "updated_date" in self.model_fields_set:
            _dict['updatedDate'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ModelsSupply from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "phone": obj.get("phone"),
            "supplyID": obj.get("supplyID"),
            "preorderID": obj.get("preorderID"),
            "createDate": obj.get("createDate"),
            "supplyDate": obj.get("supplyDate"),
            "factDate": obj.get("factDate"),
            "updatedDate": obj.get("updatedDate"),
            "statusID": obj.get("statusID")
        })
        return _obj


