# coding: utf-8

"""
    Работа с товарами

    С помощью методов этого раздела вы можете:   - [создать](/openapi/work-with-products#tag/Sozdanie-kartochek-tovarov) и [редактировать](/openapi/work-with-products#tag/Kartochki-tovarov) карточки товаров   - получить [категории, предметы, характеристики и бренды товаров](/openapi/work-with-products#tag/Kategorii-predmety-i-harakteristiki)   - загрузить [медиафайлы](/openapi/work-with-products#tag/Mediafajly) в карточки товаров   - настроить [ярлыки](/openapi/work-with-products#tag/Yarlyki) для поиска товаров   - установить [цены и скидки](/openapi/work-with-products#tag/Ceny-i-skidki)   - управлять [остатками товаров](/openapi/work-with-products#tag/Ostatki-na-skladah-prodavca) и [складами](/openapi/work-with-products#tag/Sklady-prodavca), если вы работаете по модели продаж со склада продавца    <div class=\"description_ref\">   Узнать, как использовать методы в бизнес-кейсах, можно в <a href=\"https://dev.wildberries.ru/news/101\">инструкции по работе с товарами</a>   </div> 

    The version of the OpenAPI document: products
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from wildberries_sdk.products.models.request_move_nms_imt_conn import RequestMoveNmsImtConn
from wildberries_sdk.products.models.request_move_nms_imt_disconn import RequestMoveNmsImtDisconn
from pydantic import StrictStr, Field
from typing import Union, List, Set, Optional, Dict
from typing_extensions import Literal, Self

CONTENTV2CARDSMOVENMPOSTREQUEST_ONE_OF_SCHEMAS = ["RequestMoveNmsImtConn", "RequestMoveNmsImtDisconn"]

class ContentV2CardsMoveNmPostRequest(BaseModel):
    """
    ContentV2CardsMoveNmPostRequest
    """
    # data type: RequestMoveNmsImtConn
    oneof_schema_1_validator: Optional[RequestMoveNmsImtConn] = None
    # data type: RequestMoveNmsImtDisconn
    oneof_schema_2_validator: Optional[RequestMoveNmsImtDisconn] = None
    actual_instance: Optional[Union[RequestMoveNmsImtConn, RequestMoveNmsImtDisconn]] = None
    one_of_schemas: Set[str] = { "RequestMoveNmsImtConn", "RequestMoveNmsImtDisconn" }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = ContentV2CardsMoveNmPostRequest.model_construct()
        error_messages = []
        match = 0
        # validate data type: RequestMoveNmsImtConn
        if not isinstance(v, RequestMoveNmsImtConn):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RequestMoveNmsImtConn`")
        else:
            match += 1
        # validate data type: RequestMoveNmsImtDisconn
        if not isinstance(v, RequestMoveNmsImtDisconn):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RequestMoveNmsImtDisconn`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in ContentV2CardsMoveNmPostRequest with oneOf schemas: RequestMoveNmsImtConn, RequestMoveNmsImtDisconn. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in ContentV2CardsMoveNmPostRequest with oneOf schemas: RequestMoveNmsImtConn, RequestMoveNmsImtDisconn. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # deserialize data into RequestMoveNmsImtConn
        try:
            instance.actual_instance = RequestMoveNmsImtConn.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into RequestMoveNmsImtDisconn
        try:
            instance.actual_instance = RequestMoveNmsImtDisconn.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into ContentV2CardsMoveNmPostRequest with oneOf schemas: RequestMoveNmsImtConn, RequestMoveNmsImtDisconn. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into ContentV2CardsMoveNmPostRequest with oneOf schemas: RequestMoveNmsImtConn, RequestMoveNmsImtDisconn. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], RequestMoveNmsImtConn, RequestMoveNmsImtDisconn]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


