# coding: utf-8

"""
    Работа с товарами

    С помощью методов этого раздела вы можете:   - [создать](/openapi/work-with-products#tag/Sozdanie-kartochek-tovarov) и [редактировать](/openapi/work-with-products#tag/Kartochki-tovarov) карточки товаров   - получить [категории, предметы, характеристики и бренды товаров](/openapi/work-with-products#tag/Kategorii-predmety-i-harakteristiki)   - загрузить [медиафайлы](/openapi/work-with-products#tag/Mediafajly) в карточки товаров   - настроить [ярлыки](/openapi/work-with-products#tag/Yarlyki) для поиска товаров   - установить [цены и скидки](/openapi/work-with-products#tag/Ceny-i-skidki)   - управлять [остатками товаров](/openapi/work-with-products#tag/Ostatki-na-skladah-prodavca) и [складами](/openapi/work-with-products#tag/Sklady-prodavca), если вы работаете по модели продаж со склада продавца    <div class=\"description_ref\">   Узнать, как использовать методы в бизнес-кейсах, можно в <a href=\"https://dev.wildberries.ru/news/101\">инструкции по работе с товарами</a>   </div> 

    The version of the OpenAPI document: products
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from wildberries_sdk.products.models.content_v2_cards_update_post_request_inner_characteristics_inner import ContentV2CardsUpdatePostRequestInnerCharacteristicsInner
from wildberries_sdk.products.models.content_v2_cards_update_post_request_inner_dimensions import ContentV2CardsUpdatePostRequestInnerDimensions
from wildberries_sdk.products.models.content_v2_cards_update_post_request_inner_sizes_inner import ContentV2CardsUpdatePostRequestInnerSizesInner
from typing import Optional, Set
from typing_extensions import Self

class ContentV2CardsUpdatePostRequestInner(BaseModel):
    """
    ContentV2CardsUpdatePostRequestInner
    """ # noqa: E501
    nm_id: StrictInt = Field(description="Артикул WB", alias="nmID")
    vendor_code: StrictStr = Field(description="Артикул продавца", alias="vendorCode")
    brand: Optional[StrictStr] = Field(default=None, description="Бренд")
    title: Optional[Annotated[str, Field(strict=True, max_length=60)]] = Field(default=None, description="Наименование товара")
    description: Optional[StrictStr] = Field(default=None, description="Описание товара<br> Максимальное количество символов зависит от категории товара<br> Стандарт — 2000, минимум — 1000, максимум — 5000<br> Подробно о правилах описания в **Правилах заполнения карточки товара** в [Справочном центре](https://seller.wildberries.ru/help-center/article/A-113) на портале продавцов ")
    dimensions: Optional[ContentV2CardsUpdatePostRequestInnerDimensions] = None
    characteristics: Optional[List[ContentV2CardsUpdatePostRequestInnerCharacteristicsInner]] = Field(default=None, description="Характеристики товара. <br> Можно получить методом [Характеристики предмета](./work-with-products#tag/Kategorii-predmety-i-harakteristiki/paths/~1content~1v2~1object~1charcs~1%7BsubjectId%7D/get) ")
    sizes: List[ContentV2CardsUpdatePostRequestInnerSizesInner] = Field(description="Массив размеров<br> Для безразмерного товара всё равно нужно передавать данный массив без параметров (wbSize и techSize), но с баркодом ")
    __properties: ClassVar[List[str]] = ["nmID", "vendorCode", "brand", "title", "description", "dimensions", "characteristics", "sizes"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ContentV2CardsUpdatePostRequestInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of dimensions
        if self.dimensions:
            _dict['dimensions'] = self.dimensions.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in characteristics (list)
        _items = []
        if self.characteristics:
            for _item_characteristics in self.characteristics:
                if _item_characteristics:
                    _items.append(_item_characteristics.to_dict())
            _dict['characteristics'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in sizes (list)
        _items = []
        if self.sizes:
            for _item_sizes in self.sizes:
                if _item_sizes:
                    _items.append(_item_sizes.to_dict())
            _dict['sizes'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ContentV2CardsUpdatePostRequestInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "nmID": obj.get("nmID"),
            "vendorCode": obj.get("vendorCode"),
            "brand": obj.get("brand"),
            "title": obj.get("title"),
            "description": obj.get("description"),
            "dimensions": ContentV2CardsUpdatePostRequestInnerDimensions.from_dict(obj["dimensions"]) if obj.get("dimensions") is not None else None,
            "characteristics": [ContentV2CardsUpdatePostRequestInnerCharacteristicsInner.from_dict(_item) for _item in obj["characteristics"]] if obj.get("characteristics") is not None else None,
            "sizes": [ContentV2CardsUpdatePostRequestInnerSizesInner.from_dict(_item) for _item in obj["sizes"]] if obj.get("sizes") is not None else None
        })
        return _obj


