# coding: utf-8

"""
    Работа с товарами

    С помощью методов этого раздела вы можете:   - [создать](/openapi/work-with-products#tag/Sozdanie-kartochek-tovarov) и [редактировать](/openapi/work-with-products#tag/Kartochki-tovarov) карточки товаров   - получить [категории, предметы, характеристики и бренды товаров](/openapi/work-with-products#tag/Kategorii-predmety-i-harakteristiki)   - загрузить [медиафайлы](/openapi/work-with-products#tag/Mediafajly) в карточки товаров   - настроить [ярлыки](/openapi/work-with-products#tag/Yarlyki) для поиска товаров   - установить [цены и скидки](/openapi/work-with-products#tag/Ceny-i-skidki)   - управлять [остатками товаров](/openapi/work-with-products#tag/Ostatki-na-skladah-prodavca) и [складами](/openapi/work-with-products#tag/Sklady-prodavca), если вы работаете по модели продаж со склада продавца    <div class=\"description_ref\">   Узнать, как использовать методы в бизнес-кейсах, можно в <a href=\"https://dev.wildberries.ru/news/101\">инструкции по работе с товарами</a>   </div> 

    The version of the OpenAPI document: products
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from wildberries_sdk.products.models.content_v2_get_cards_list_post200_response_cards_inner_characteristics_inner import ContentV2GetCardsListPost200ResponseCardsInnerCharacteristicsInner
from wildberries_sdk.products.models.content_v2_get_cards_list_post200_response_cards_inner_dimensions import ContentV2GetCardsListPost200ResponseCardsInnerDimensions
from wildberries_sdk.products.models.content_v2_get_cards_list_post200_response_cards_inner_photos_inner import ContentV2GetCardsListPost200ResponseCardsInnerPhotosInner
from wildberries_sdk.products.models.content_v2_get_cards_list_post200_response_cards_inner_wholesale import ContentV2GetCardsListPost200ResponseCardsInnerWholesale
from wildberries_sdk.products.models.content_v2_get_cards_trash_post200_response_cards_inner_sizes_inner import ContentV2GetCardsTrashPost200ResponseCardsInnerSizesInner
from typing import Optional, Set
from typing_extensions import Self

class ContentV2GetCardsTrashPost200ResponseCardsInner(BaseModel):
    """
    ContentV2GetCardsTrashPost200ResponseCardsInner
    """ # noqa: E501
    nm_id: Optional[StrictInt] = Field(default=None, description="Артикул WB", alias="nmID")
    vendor_code: Optional[StrictStr] = Field(default=None, description="Артикул продавца", alias="vendorCode")
    subject_id: Optional[StrictInt] = Field(default=None, description="ID предмета", alias="subjectID")
    subject_name: Optional[StrictStr] = Field(default=None, description="Название предмета", alias="subjectName")
    photos: Optional[List[ContentV2GetCardsListPost200ResponseCardsInnerPhotosInner]] = Field(default=None, description="Массив фото")
    video: Optional[StrictStr] = Field(default=None, description="URL видео")
    wholesale: Optional[ContentV2GetCardsListPost200ResponseCardsInnerWholesale] = None
    sizes: Optional[List[ContentV2GetCardsTrashPost200ResponseCardsInnerSizesInner]] = Field(default=None, description="Массив размеров")
    dimensions: Optional[ContentV2GetCardsListPost200ResponseCardsInnerDimensions] = None
    characteristics: Optional[List[ContentV2GetCardsListPost200ResponseCardsInnerCharacteristicsInner]] = Field(default=None, description="Характеристики")
    created_at: Optional[StrictStr] = Field(default=None, description="Date and time the card was created", alias="createdAt")
    trashed_at: Optional[StrictStr] = Field(default=None, description="Дата и время помещения в корзину", alias="trashedAt")
    __properties: ClassVar[List[str]] = ["nmID", "vendorCode", "subjectID", "subjectName", "photos", "video", "wholesale", "sizes", "dimensions", "characteristics", "createdAt", "trashedAt"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ContentV2GetCardsTrashPost200ResponseCardsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in photos (list)
        _items = []
        if self.photos:
            for _item_photos in self.photos:
                if _item_photos:
                    _items.append(_item_photos.to_dict())
            _dict['photos'] = _items
        # override the default output from pydantic by calling `to_dict()` of wholesale
        if self.wholesale:
            _dict['wholesale'] = self.wholesale.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in sizes (list)
        _items = []
        if self.sizes:
            for _item_sizes in self.sizes:
                if _item_sizes:
                    _items.append(_item_sizes.to_dict())
            _dict['sizes'] = _items
        # override the default output from pydantic by calling `to_dict()` of dimensions
        if self.dimensions:
            _dict['dimensions'] = self.dimensions.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in characteristics (list)
        _items = []
        if self.characteristics:
            for _item_characteristics in self.characteristics:
                if _item_characteristics:
                    _items.append(_item_characteristics.to_dict())
            _dict['characteristics'] = _items
        # set to None if characteristics (nullable) is None
        # and model_fields_set contains the field
        if self.characteristics is None and "characteristics" in self.model_fields_set:
            _dict['characteristics'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ContentV2GetCardsTrashPost200ResponseCardsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "nmID": obj.get("nmID"),
            "vendorCode": obj.get("vendorCode"),
            "subjectID": obj.get("subjectID"),
            "subjectName": obj.get("subjectName"),
            "photos": [ContentV2GetCardsListPost200ResponseCardsInnerPhotosInner.from_dict(_item) for _item in obj["photos"]] if obj.get("photos") is not None else None,
            "video": obj.get("video"),
            "wholesale": ContentV2GetCardsListPost200ResponseCardsInnerWholesale.from_dict(obj["wholesale"]) if obj.get("wholesale") is not None else None,
            "sizes": [ContentV2GetCardsTrashPost200ResponseCardsInnerSizesInner.from_dict(_item) for _item in obj["sizes"]] if obj.get("sizes") is not None else None,
            "dimensions": ContentV2GetCardsListPost200ResponseCardsInnerDimensions.from_dict(obj["dimensions"]) if obj.get("dimensions") is not None else None,
            "characteristics": [ContentV2GetCardsListPost200ResponseCardsInnerCharacteristicsInner.from_dict(_item) for _item in obj["characteristics"]] if obj.get("characteristics") is not None else None,
            "createdAt": obj.get("createdAt"),
            "trashedAt": obj.get("trashedAt")
        })
        return _obj


