# coding: utf-8

"""
    Работа с товарами

    С помощью методов этого раздела вы можете:   - [создать](/openapi/work-with-products#tag/Sozdanie-kartochek-tovarov) и [редактировать](/openapi/work-with-products#tag/Kartochki-tovarov) карточки товаров   - получить [категории, предметы, характеристики и бренды товаров](/openapi/work-with-products#tag/Kategorii-predmety-i-harakteristiki)   - загрузить [медиафайлы](/openapi/work-with-products#tag/Mediafajly) в карточки товаров   - настроить [ярлыки](/openapi/work-with-products#tag/Yarlyki) для поиска товаров   - установить [цены и скидки](/openapi/work-with-products#tag/Ceny-i-skidki)   - управлять [остатками товаров](/openapi/work-with-products#tag/Ostatki-na-skladah-prodavca) и [складами](/openapi/work-with-products#tag/Sklady-prodavca), если вы работаете по модели продаж со склада продавца    <div class=\"description_ref\">   Узнать, как использовать методы в бизнес-кейсах, можно в <a href=\"https://dev.wildberries.ru/news/101\">инструкции по работе с товарами</a>   </div> 

    The version of the OpenAPI document: products
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class ContentV2ObjectCharcsSubjectIdGet200ResponseDataInner(BaseModel):
    """
    ContentV2ObjectCharcsSubjectIdGet200ResponseDataInner
    """ # noqa: E501
    charc_id: Optional[StrictInt] = Field(default=None, description="ID характеристики", alias="charcID")
    subject_name: Optional[StrictStr] = Field(default=None, description="Название предмета", alias="subjectName")
    subject_id: Optional[StrictInt] = Field(default=None, description="ID предмета", alias="subjectID")
    name: Optional[StrictStr] = Field(default=None, description="Название характеристики")
    required: Optional[StrictBool] = Field(default=None, description="- `true` - характеристику необходимо обязательно указать в карточке товара - `false` - характеристику необязательно указывать ")
    unit_name: Optional[StrictStr] = Field(default=None, description="Единица измерения", alias="unitName")
    max_count: Optional[StrictInt] = Field(default=None, description="Максимальное количество значений, которое можно присвоить характеристике при [создании](./work-with-products#tag/Sozdanie-kartochek-tovarov) или [редактировании](./work-with-products#tag/Kartochki-tovarov/paths/~1content~1v2~1cards~1update/post) карточек товаров. <br> Используется только для характеристик с `\"charcType\":1`— массив строк. <br> Характеристикам с `\"charcType\":4`— число, можно присвоить только одно значение. <br><br> Если `\"maxCount\":0`, количество значений не ограничено ", alias="maxCount")
    popular: Optional[StrictBool] = Field(default=None, description="Характеристика популярна у пользователей (true - да, false - нет)")
    charc_type: Optional[StrictInt] = Field(default=None, description="Тип данных характеристики, который необходимо использовать при [создании](./work-with-products#tag/Sozdanie-kartochek-tovarov) или [редактировании](./work-with-products#tag/Kartochki-tovarov/paths/~1content~1v2~1cards~1update/post) карточек товаров:   -  `1` — массив строк   -  `4` — число   -  `0` — характеристика не используется ", alias="charcType")
    __properties: ClassVar[List[str]] = ["charcID", "subjectName", "subjectID", "name", "required", "unitName", "maxCount", "popular", "charcType"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ContentV2ObjectCharcsSubjectIdGet200ResponseDataInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ContentV2ObjectCharcsSubjectIdGet200ResponseDataInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "charcID": obj.get("charcID"),
            "subjectName": obj.get("subjectName"),
            "subjectID": obj.get("subjectID"),
            "name": obj.get("name"),
            "required": obj.get("required"),
            "unitName": obj.get("unitName"),
            "maxCount": obj.get("maxCount"),
            "popular": obj.get("popular"),
            "charcType": obj.get("charcType")
        })
        return _obj


