# coding: utf-8

"""
    Работа с товарами

    С помощью методов этого раздела вы можете:   - [создать](/openapi/work-with-products#tag/Sozdanie-kartochek-tovarov) и [редактировать](/openapi/work-with-products#tag/Kartochki-tovarov) карточки товаров   - получить [категории, предметы, характеристики и бренды товаров](/openapi/work-with-products#tag/Kategorii-predmety-i-harakteristiki)   - загрузить [медиафайлы](/openapi/work-with-products#tag/Mediafajly) в карточки товаров   - настроить [ярлыки](/openapi/work-with-products#tag/Yarlyki) для поиска товаров   - установить [цены и скидки](/openapi/work-with-products#tag/Ceny-i-skidki)   - управлять [остатками товаров](/openapi/work-with-products#tag/Ostatki-na-skladah-prodavca) и [складами](/openapi/work-with-products#tag/Sklady-prodavca), если вы работаете по модели продаж со склада продавца    <div class=\"description_ref\">   Узнать, как использовать методы в бизнес-кейсах, можно в <a href=\"https://dev.wildberries.ru/news/101\">инструкции по работе с товарами</a>   </div> 

    The version of the OpenAPI document: products
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List
from wildberries_sdk.products.models.models_error_brand import ModelsErrorBrand
from wildberries_sdk.products.models.models_error_subject import ModelsErrorSubject
from typing import Optional, Set
from typing_extensions import Self

class ModelsErrorTableListPublicRespV2Item(BaseModel):
    """
    ModelsErrorTableListPublicRespV2Item
    """ # noqa: E501
    batch_uuid: StrictStr = Field(description="ID пакета", alias="batchUUID")
    subjects: Dict[str, ModelsErrorSubject] = Field(description="Предметы. Разбивка по `vendorCodes`")
    brands: Dict[str, ModelsErrorBrand] = Field(description="Бренды. Разбивка по `vendorCodes`")
    vendor_codes: List[StrictStr] = Field(description="Артикулы продавца", alias="vendorCodes")
    errors: Dict[str, List[StrictStr]] = Field(description="Ошибки. Разбивка по `vendorCodes`")
    __properties: ClassVar[List[str]] = ["batchUUID", "subjects", "brands", "vendorCodes", "errors"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ModelsErrorTableListPublicRespV2Item from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each value in subjects (dict)
        _field_dict = {}
        if self.subjects:
            for _key_subjects in self.subjects:
                if self.subjects[_key_subjects]:
                    _field_dict[_key_subjects] = self.subjects[_key_subjects].to_dict()
            _dict['subjects'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each value in brands (dict)
        _field_dict = {}
        if self.brands:
            for _key_brands in self.brands:
                if self.brands[_key_brands]:
                    _field_dict[_key_brands] = self.brands[_key_brands].to_dict()
            _dict['brands'] = _field_dict
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ModelsErrorTableListPublicRespV2Item from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "batchUUID": obj.get("batchUUID"),
            "subjects": dict(
                (_k, ModelsErrorSubject.from_dict(_v))
                for _k, _v in obj["subjects"].items()
            )
            if obj.get("subjects") is not None
            else None,
            "brands": dict(
                (_k, ModelsErrorBrand.from_dict(_v))
                for _k, _v in obj["brands"].items()
            )
            if obj.get("brands") is not None
            else None,
            "vendorCodes": obj.get("vendorCodes"),
            "errors": obj.get("errors")
        })
        return _obj


