# coding: utf-8

"""
    Работа с товарами

    С помощью методов этого раздела вы можете:   - [создать](/openapi/work-with-products#tag/Sozdanie-kartochek-tovarov) и [редактировать](/openapi/work-with-products#tag/Kartochki-tovarov) карточки товаров   - получить [категории, предметы, характеристики и бренды товаров](/openapi/work-with-products#tag/Kategorii-predmety-i-harakteristiki)   - загрузить [медиафайлы](/openapi/work-with-products#tag/Mediafajly) в карточки товаров   - настроить [ярлыки](/openapi/work-with-products#tag/Yarlyki) для поиска товаров   - установить [цены и скидки](/openapi/work-with-products#tag/Ceny-i-skidki)   - управлять [остатками товаров](/openapi/work-with-products#tag/Ostatki-na-skladah-prodavca) и [складами](/openapi/work-with-products#tag/Sklady-prodavca), если вы работаете по модели продаж со склада продавца    <div class=\"description_ref\">   Узнать, как использовать методы в бизнес-кейсах, можно в <a href=\"https://dev.wildberries.ru/news/101\">инструкции по работе с товарами</a>   </div> 

    The version of the OpenAPI document: products
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class Office(BaseModel):
    """
    Данные о складе WB
    """ # noqa: E501
    address: Optional[StrictStr] = Field(default=None, description="Адрес")
    name: Optional[StrictStr] = Field(default=None, description="Название")
    city: Optional[StrictStr] = Field(default=None, description="Город")
    id: Optional[StrictInt] = Field(default=None, description="ID")
    longitude: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Долгота")
    latitude: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Широта")
    cargo_type: Optional[StrictInt] = Field(default=None, description="Тип товара, который принимает склад:   - `1` — малогабаритный товар (МГТ)   - `2` — сверхгабаритный товар (СГТ)   - `3` — крупногабаритный товар (КГТ+) ", alias="cargoType")
    delivery_type: Optional[StrictInt] = Field(default=None, description="Тип доставки, который принимает склад:   - `1` — доставка на склад WB (FBS)   - `2` — доставка силами продавца (DBS)   - `3` — доставка курьером WB (DBW)   - `5` — самовывоз (C&C)   - `6` — экспресс-доставка силами продавца (ЕDBS) ", alias="deliveryType")
    federal_district: Optional[StrictStr] = Field(default=None, description="Федеральный округ склада WB. Если `null`, склад находится за пределами РФ или федеральный округ не указан", alias="federalDistrict")
    selected: Optional[StrictBool] = Field(default=None, description="Признак того, что склад уже выбран продавцом")
    __properties: ClassVar[List[str]] = ["address", "name", "city", "id", "longitude", "latitude", "cargoType", "deliveryType", "federalDistrict", "selected"]

    @field_validator('cargo_type')
    def cargo_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set([1, 2, 3]):
            raise ValueError("must be one of enum values (1, 2, 3)")
        return value

    @field_validator('delivery_type')
    def delivery_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set([1, 2, 3, 5, 6]):
            raise ValueError("must be one of enum values (1, 2, 3, 5, 6)")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Office from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if federal_district (nullable) is None
        # and model_fields_set contains the field
        if self.federal_district is None and "federal_district" in self.model_fields_set:
            _dict['federalDistrict'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Office from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "address": obj.get("address"),
            "name": obj.get("name"),
            "city": obj.get("city"),
            "id": obj.get("id"),
            "longitude": obj.get("longitude"),
            "latitude": obj.get("latitude"),
            "cargoType": obj.get("cargoType"),
            "deliveryType": obj.get("deliveryType"),
            "federalDistrict": obj.get("federalDistrict"),
            "selected": obj.get("selected")
        })
        return _obj


