# coding: utf-8

"""
    Работа с товарами

    С помощью методов этого раздела вы можете:   - [создать](/openapi/work-with-products#tag/Sozdanie-kartochek-tovarov) и [редактировать](/openapi/work-with-products#tag/Kartochki-tovarov) карточки товаров   - получить [категории, предметы, характеристики и бренды товаров](/openapi/work-with-products#tag/Kategorii-predmety-i-harakteristiki)   - загрузить [медиафайлы](/openapi/work-with-products#tag/Mediafajly) в карточки товаров   - настроить [ярлыки](/openapi/work-with-products#tag/Yarlyki) для поиска товаров   - установить [цены и скидки](/openapi/work-with-products#tag/Ceny-i-skidki)   - управлять [остатками товаров](/openapi/work-with-products#tag/Ostatki-na-skladah-prodavca) и [складами](/openapi/work-with-products#tag/Sklady-prodavca), если вы работаете по модели продаж со склада продавца    <div class=\"description_ref\">   Узнать, как использовать методы в бизнес-кейсах, можно в <a href=\"https://dev.wildberries.ru/news/101\">инструкции по работе с товарами</a>   </div> 

    The version of the OpenAPI document: products
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class QuarantineGoods(BaseModel):
    """
    QuarantineGoods
    """ # noqa: E501
    nm_id: Optional[StrictInt] = Field(default=None, description="Артикул WB", alias="nmID")
    size_id: Optional[StrictInt] = Field(default=None, description="Не используется", alias="sizeID")
    tech_size_name: Optional[StrictStr] = Field(default=None, description="Не используется", alias="techSizeName")
    currency_iso_code4217: Optional[StrictStr] = Field(default=None, description="Валюта по стандарту ISO 4217", alias="currencyIsoCode4217")
    new_price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Новая цена продавца до скидки", alias="newPrice")
    old_price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Текущая цена продавца до скидки", alias="oldPrice")
    new_discount: Optional[StrictInt] = Field(default=None, description="Новая скидка продавца, %", alias="newDiscount")
    old_discount: Optional[StrictInt] = Field(default=None, description="Текущая скидка продавца, %", alias="oldDiscount")
    price_diff: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Разница: `newPrice` * (1 - `newDiscount` / 100) - `oldPrice` * (1 - `oldDiscount` / 100)", alias="priceDiff")
    __properties: ClassVar[List[str]] = ["nmID", "sizeID", "techSizeName", "currencyIsoCode4217", "newPrice", "oldPrice", "newDiscount", "oldDiscount", "priceDiff"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of QuarantineGoods from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if size_id (nullable) is None
        # and model_fields_set contains the field
        if self.size_id is None and "size_id" in self.model_fields_set:
            _dict['sizeID'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of QuarantineGoods from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "nmID": obj.get("nmID"),
            "sizeID": obj.get("sizeID"),
            "techSizeName": obj.get("techSizeName"),
            "currencyIsoCode4217": obj.get("currencyIsoCode4217"),
            "newPrice": obj.get("newPrice"),
            "oldPrice": obj.get("oldPrice"),
            "newDiscount": obj.get("newDiscount"),
            "oldDiscount": obj.get("oldDiscount"),
            "priceDiff": obj.get("priceDiff")
        })
        return _obj


