# coding: utf-8

"""
    Работа с товарами

    С помощью методов этого раздела вы можете:   - [создать](/openapi/work-with-products#tag/Sozdanie-kartochek-tovarov) и [редактировать](/openapi/work-with-products#tag/Kartochki-tovarov) карточки товаров   - получить [категории, предметы, характеристики и бренды товаров](/openapi/work-with-products#tag/Kategorii-predmety-i-harakteristiki)   - загрузить [медиафайлы](/openapi/work-with-products#tag/Mediafajly) в карточки товаров   - настроить [ярлыки](/openapi/work-with-products#tag/Yarlyki) для поиска товаров   - установить [цены и скидки](/openapi/work-with-products#tag/Ceny-i-skidki)   - управлять [остатками товаров](/openapi/work-with-products#tag/Ostatki-na-skladah-prodavca) и [складами](/openapi/work-with-products#tag/Sklady-prodavca), если вы работаете по модели продаж со склада продавца    <div class=\"description_ref\">   Узнать, как использовать методы в бизнес-кейсах, можно в <a href=\"https://dev.wildberries.ru/news/101\">инструкции по работе с товарами</a>   </div> 

    The version of the OpenAPI document: products
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from wildberries_sdk.products.models.response_card_create_additional_errors_one_of import ResponseCardCreateAdditionalErrorsOneOf
from wildberries_sdk.products.models.response_card_create_additional_errors_one_of1 import ResponseCardCreateAdditionalErrorsOneOf1
from pydantic import StrictStr, Field
from typing import Union, List, Set, Optional, Dict
from typing_extensions import Literal, Self

RESPONSECARDCREATEADDITIONALERRORS_ONE_OF_SCHEMAS = ["ResponseCardCreateAdditionalErrorsOneOf", "ResponseCardCreateAdditionalErrorsOneOf1", "str"]

class ResponseCardCreateAdditionalErrors(BaseModel):
    """
    Дополнительные ошибки
    """
    # data type: ResponseCardCreateAdditionalErrorsOneOf
    oneof_schema_1_validator: Optional[ResponseCardCreateAdditionalErrorsOneOf] = None
    # data type: str
    oneof_schema_2_validator: Optional[StrictStr] = None
    # data type: ResponseCardCreateAdditionalErrorsOneOf1
    oneof_schema_3_validator: Optional[ResponseCardCreateAdditionalErrorsOneOf1] = None
    actual_instance: Optional[Union[ResponseCardCreateAdditionalErrorsOneOf, ResponseCardCreateAdditionalErrorsOneOf1, str]] = None
    one_of_schemas: Set[str] = { "ResponseCardCreateAdditionalErrorsOneOf", "ResponseCardCreateAdditionalErrorsOneOf1", "str" }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = ResponseCardCreateAdditionalErrors.model_construct()
        error_messages = []
        match = 0
        # validate data type: ResponseCardCreateAdditionalErrorsOneOf
        if not isinstance(v, ResponseCardCreateAdditionalErrorsOneOf):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ResponseCardCreateAdditionalErrorsOneOf`")
        else:
            match += 1
        # validate data type: str
        try:
            instance.oneof_schema_2_validator = v
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # validate data type: ResponseCardCreateAdditionalErrorsOneOf1
        if not isinstance(v, ResponseCardCreateAdditionalErrorsOneOf1):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ResponseCardCreateAdditionalErrorsOneOf1`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in ResponseCardCreateAdditionalErrors with oneOf schemas: ResponseCardCreateAdditionalErrorsOneOf, ResponseCardCreateAdditionalErrorsOneOf1, str. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in ResponseCardCreateAdditionalErrors with oneOf schemas: ResponseCardCreateAdditionalErrorsOneOf, ResponseCardCreateAdditionalErrorsOneOf1, str. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # deserialize data into ResponseCardCreateAdditionalErrorsOneOf
        try:
            instance.actual_instance = ResponseCardCreateAdditionalErrorsOneOf.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into str
        try:
            # validation
            instance.oneof_schema_2_validator = json.loads(json_str)
            # assign value to actual_instance
            instance.actual_instance = instance.oneof_schema_2_validator
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into ResponseCardCreateAdditionalErrorsOneOf1
        try:
            instance.actual_instance = ResponseCardCreateAdditionalErrorsOneOf1.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into ResponseCardCreateAdditionalErrors with oneOf schemas: ResponseCardCreateAdditionalErrorsOneOf, ResponseCardCreateAdditionalErrorsOneOf1, str. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into ResponseCardCreateAdditionalErrors with oneOf schemas: ResponseCardCreateAdditionalErrorsOneOf, ResponseCardCreateAdditionalErrorsOneOf1, str. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], ResponseCardCreateAdditionalErrorsOneOf, ResponseCardCreateAdditionalErrorsOneOf1, str]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


