# coding: utf-8

"""
    Маркетинг и продвижение

    <div class=\"description_important\">     Узнать больше о маркетинге и продвижении можно в <a href=\"https://seller.wildberries.ru/instructions/category/59d92bd3-6ea0-40f2-b762-ca8835d7d42e?goBackOption=prevRoute&categoryId=479385c6-de01-4b4d-ad4e-ed941e65582e\">справочном центре</a> </div>  Методы маркетинга и продвижения позволяют:   1. Получать информацию о кампаниях [продвижения](/openapi/promotion#tag/Kampanii) и [медиакампаниях](/openapi/promotion#tag/Media).   2. [Создавать](/openapi/promotion#tag/Sozdanie-kampanij) и [управлять](/openapi/promotion#tag/Upravlenie-kampaniyami) кампаниями.   3. Настраивать [параметры](/openapi/promotion#tag/Parametry-kampanij) кампаний — кластеры фраз, продвигаемые товары и так далее.   4. Управлять [финансами](/openapi/promotion#tag/Finansy) кампаний.   5. Выгружать [статистику](/openapi/promotion#tag/Statistika) кампаний продвижения и медиакампаний.   6. Работать с [календарём акций](/openapi/promotion#tag/Kalendar-akcij).  Данные синхронизируются с базой раз в 3 минуты. Статусы кампаний меняются раз в минуту. Ставки кампаний меняются раз в 30 секунд. 

    The version of the OpenAPI document: promotion
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from wildberries_sdk.promotion.models.adv_v1_advert_get200_response_extended import AdvV1AdvertGet200ResponseExtended
from wildberries_sdk.promotion.models.adv_v1_advert_get200_response_items_inner import AdvV1AdvertGet200ResponseItemsInner
from typing import Optional, Set
from typing_extensions import Self

class AdvV1AdvertGet200Response(BaseModel):
    """
    AdvV1AdvertGet200Response
    """ # noqa: E501
    advert_id: Optional[StrictInt] = Field(default=None, description="ID медиакампании", alias="advertId")
    name: Optional[StrictStr] = Field(default=None, description="Название медиакампании")
    brand: Optional[StrictStr] = Field(default=None, description="Название бренда")
    type: Optional[StrictInt] = Field(default=None, description="Тип медиакампании: - `1` — размещение по дням - `2` — размещение по просмотрам ")
    status: Optional[StrictInt] = Field(default=None, description="Статус медиакампании:   - `1` — черновик   - `2` — модерация   - `3` — отклонена (с возможностью вернуть на модерацию)   - `4` — готова к запуску   - `5` — запланирована   - `6` — на показах   - `7` — завершена   - `8` — отменена   - `9` — приостановлена продавцом   - `10` — пауза по дневному лимиту   - `11` — пауза ")
    create_time: Optional[datetime] = Field(default=None, description="Время создания медиакампании", alias="createTime")
    extended: Optional[AdvV1AdvertGet200ResponseExtended] = None
    items: Optional[List[AdvV1AdvertGet200ResponseItemsInner]] = Field(default=None, description="Информация о баннере. <br> Наличие в ответе тех или иных полей зависит от конфигурации медиакампании. ")
    __properties: ClassVar[List[str]] = ["advertId", "name", "brand", "type", "status", "createTime", "extended", "items"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AdvV1AdvertGet200Response from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of extended
        if self.extended:
            _dict['extended'] = self.extended.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in items (list)
        _items = []
        if self.items:
            for _item_items in self.items:
                if _item_items:
                    _items.append(_item_items.to_dict())
            _dict['items'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AdvV1AdvertGet200Response from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "advertId": obj.get("advertId"),
            "name": obj.get("name"),
            "brand": obj.get("brand"),
            "type": obj.get("type"),
            "status": obj.get("status"),
            "createTime": obj.get("createTime"),
            "extended": AdvV1AdvertGet200ResponseExtended.from_dict(obj["extended"]) if obj.get("extended") is not None else None,
            "items": [AdvV1AdvertGet200ResponseItemsInner.from_dict(_item) for _item in obj["items"]] if obj.get("items") is not None else None
        })
        return _obj


