# coding: utf-8

"""
    Маркетинг и продвижение

    <div class=\"description_important\">     Узнать больше о маркетинге и продвижении можно в <a href=\"https://seller.wildberries.ru/instructions/category/59d92bd3-6ea0-40f2-b762-ca8835d7d42e?goBackOption=prevRoute&categoryId=479385c6-de01-4b4d-ad4e-ed941e65582e\">справочном центре</a> </div>  Методы маркетинга и продвижения позволяют:   1. Получать информацию о кампаниях [продвижения](/openapi/promotion#tag/Kampanii) и [медиакампаниях](/openapi/promotion#tag/Media).   2. [Создавать](/openapi/promotion#tag/Sozdanie-kampanij) и [управлять](/openapi/promotion#tag/Upravlenie-kampaniyami) кампаниями.   3. Настраивать [параметры](/openapi/promotion#tag/Parametry-kampanij) кампаний — кластеры фраз, продвигаемые товары и так далее.   4. Управлять [финансами](/openapi/promotion#tag/Finansy) кампаний.   5. Выгружать [статистику](/openapi/promotion#tag/Statistika) кампаний продвижения и медиакампаний.   6. Работать с [календарём акций](/openapi/promotion#tag/Kalendar-akcij).  Данные синхронизируются с базой раз в 3 минуты. Статусы кампаний меняются раз в минуту. Ставки кампаний меняются раз в 30 секунд. 

    The version of the OpenAPI document: promotion
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from wildberries_sdk.promotion.models.adv_v1_advert_get200_response_items_inner_show_hours_inner import AdvV1AdvertGet200ResponseItemsInnerShowHoursInner
from typing import Optional, Set
from typing_extensions import Self

class AdvV1AdvertGet200ResponseItemsInner(BaseModel):
    """
    AdvV1AdvertGet200ResponseItemsInner
    """ # noqa: E501
    id: Optional[StrictInt] = Field(default=None, description="ID баннера")
    name: Optional[StrictStr] = Field(default=None, description="Бренд")
    status: Optional[StrictInt] = Field(default=None, description="Статус (такой же как у медиакампании)")
    place: Optional[StrictInt] = Field(default=None, description="Позиция на странице размещения")
    budget: Optional[StrictInt] = Field(default=None, description="Бюджет")
    daily_limit: Optional[StrictInt] = Field(default=None, description="Дневной лимит (для баннеров по показам)")
    category_name: Optional[StrictStr] = Field(default=None, description="Название категории размещения")
    cpm: Optional[StrictInt] = Field(default=None, description="Ставка")
    url: Optional[StrictStr] = Field(default=None, description="URL страницы, на которую попадает пользователь при клике по баннеру")
    advert_type: Optional[StrictInt] = Field(default=None, description="Тип продвижения: - `1` — баннер - `2` — всплывающее меню - `3` — почтовая рассылка - `4` — социальные сети - `5` — push-уведомления в мобильном приложении ")
    created_at: Optional[datetime] = Field(default=None, description="Дата создания баннера")
    updated_at: Optional[datetime] = Field(default=None, description="Дата и время обновления баннера")
    date_from: Optional[datetime] = Field(default=None, description="Дата начала работы баннера")
    date_to: Optional[datetime] = Field(default=None, description="Дата завершения работы баннера")
    nms: Optional[List[StrictInt]] = Field(default=None, description="Подборка артикулов WB")
    bottom_text1: Optional[StrictStr] = Field(default=None, description="Текст под плашкой баннера", alias="bottomText1")
    bottom_text2: Optional[StrictStr] = Field(default=None, description="2-я строка с текстом под плашкой баннера", alias="bottomText2")
    message: Optional[StrictStr] = Field(default=None, description="Текст push-уведомления или рассылки")
    additional_settings: Optional[StrictInt] = Field(default=None, description="Дополнительные настройки.  Формат почтовой рассылки: - `1` — общий - `2` — частичный - `3` — уникальный   Социальная сеть: - `1` — VK - `2` — OK (Одноклассники) ", alias="additionalSettings")
    receivers_count: Optional[StrictInt] = Field(default=None, description="Кол-во получателей push-уведомлений", alias="receiversCount")
    subject_id: Optional[StrictInt] = Field(default=None, description="ID родительской категории товара")
    subject_name: Optional[StrictStr] = Field(default=None, description="Название родительской категории товара")
    action_name: Optional[StrictStr] = Field(default=None, description="Название акции")
    show_hours: Optional[List[AdvV1AdvertGet200ResponseItemsInnerShowHoursInner]] = Field(default=None, description="Часы показа")
    erid: Optional[StrictStr] = Field(default=None, description="Уникальный ID медиакампании для работы с ОРД", alias="Erid")
    __properties: ClassVar[List[str]] = ["id", "name", "status", "place", "budget", "daily_limit", "category_name", "cpm", "url", "advert_type", "created_at", "updated_at", "date_from", "date_to", "nms", "bottomText1", "bottomText2", "message", "additionalSettings", "receiversCount", "subject_id", "subject_name", "action_name", "show_hours", "Erid"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AdvV1AdvertGet200ResponseItemsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in show_hours (list)
        _items = []
        if self.show_hours:
            for _item_show_hours in self.show_hours:
                if _item_show_hours:
                    _items.append(_item_show_hours.to_dict())
            _dict['show_hours'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AdvV1AdvertGet200ResponseItemsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "status": obj.get("status"),
            "place": obj.get("place"),
            "budget": obj.get("budget"),
            "daily_limit": obj.get("daily_limit"),
            "category_name": obj.get("category_name"),
            "cpm": obj.get("cpm"),
            "url": obj.get("url"),
            "advert_type": obj.get("advert_type"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "date_from": obj.get("date_from"),
            "date_to": obj.get("date_to"),
            "nms": obj.get("nms"),
            "bottomText1": obj.get("bottomText1"),
            "bottomText2": obj.get("bottomText2"),
            "message": obj.get("message"),
            "additionalSettings": obj.get("additionalSettings"),
            "receiversCount": obj.get("receiversCount"),
            "subject_id": obj.get("subject_id"),
            "subject_name": obj.get("subject_name"),
            "action_name": obj.get("action_name"),
            "show_hours": [AdvV1AdvertGet200ResponseItemsInnerShowHoursInner.from_dict(_item) for _item in obj["show_hours"]] if obj.get("show_hours") is not None else None,
            "Erid": obj.get("Erid")
        })
        return _obj


