# coding: utf-8

"""
    Маркетинг и продвижение

    <div class=\"description_important\">     Узнать больше о маркетинге и продвижении можно в <a href=\"https://seller.wildberries.ru/instructions/category/59d92bd3-6ea0-40f2-b762-ca8835d7d42e?goBackOption=prevRoute&categoryId=479385c6-de01-4b4d-ad4e-ed941e65582e\">справочном центре</a> </div>  Методы маркетинга и продвижения позволяют:   1. Получать информацию о кампаниях [продвижения](/openapi/promotion#tag/Kampanii) и [медиакампаниях](/openapi/promotion#tag/Media).   2. [Создавать](/openapi/promotion#tag/Sozdanie-kampanij) и [управлять](/openapi/promotion#tag/Upravlenie-kampaniyami) кампаниями.   3. Настраивать [параметры](/openapi/promotion#tag/Parametry-kampanij) кампаний — кластеры фраз, продвигаемые товары и так далее.   4. Управлять [финансами](/openapi/promotion#tag/Finansy) кампаний.   5. Выгружать [статистику](/openapi/promotion#tag/Statistika) кампаний продвижения и медиакампаний.   6. Работать с [календарём акций](/openapi/promotion#tag/Kalendar-akcij).  Данные синхронизируются с базой раз в 3 минуты. Статусы кампаний меняются раз в минуту. Ставки кампаний меняются раз в 30 секунд. 

    The version of the OpenAPI document: promotion
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from wildberries_sdk.promotion.models.adv_v1_promotion_count_get200_response_adverts_inner import AdvV1PromotionCountGet200ResponseAdvertsInner
from typing import Optional, Set
from typing_extensions import Self

class AdvV1PromotionCountGet200Response(BaseModel):
    """
    AdvV1PromotionCountGet200Response
    """ # noqa: E501
    adverts: Optional[List[AdvV1PromotionCountGet200ResponseAdvertsInner]] = Field(default=None, description="Данные по кампаниям")
    all: Optional[StrictInt] = Field(default=None, description="Общее количество кампаний всех статусов и типов")
    __properties: ClassVar[List[str]] = ["adverts", "all"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AdvV1PromotionCountGet200Response from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in adverts (list)
        _items = []
        if self.adverts:
            for _item_adverts in self.adverts:
                if _item_adverts:
                    _items.append(_item_adverts.to_dict())
            _dict['adverts'] = _items
        # set to None if adverts (nullable) is None
        # and model_fields_set contains the field
        if self.adverts is None and "adverts" in self.model_fields_set:
            _dict['adverts'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AdvV1PromotionCountGet200Response from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "adverts": [AdvV1PromotionCountGet200ResponseAdvertsInner.from_dict(_item) for _item in obj["adverts"]] if obj.get("adverts") is not None else None,
            "all": obj.get("all")
        })
        return _obj


