# coding: utf-8

"""
    Маркетинг и продвижение

    <div class=\"description_important\">     Узнать больше о маркетинге и продвижении можно в <a href=\"https://seller.wildberries.ru/instructions/category/59d92bd3-6ea0-40f2-b762-ca8835d7d42e?goBackOption=prevRoute&categoryId=479385c6-de01-4b4d-ad4e-ed941e65582e\">справочном центре</a> </div>  Методы маркетинга и продвижения позволяют:   1. Получать информацию о кампаниях [продвижения](/openapi/promotion#tag/Kampanii) и [медиакампаниях](/openapi/promotion#tag/Media).   2. [Создавать](/openapi/promotion#tag/Sozdanie-kampanij) и [управлять](/openapi/promotion#tag/Upravlenie-kampaniyami) кампаниями.   3. Настраивать [параметры](/openapi/promotion#tag/Parametry-kampanij) кампаний — кластеры фраз, продвигаемые товары и так далее.   4. Управлять [финансами](/openapi/promotion#tag/Finansy) кампаний.   5. Выгружать [статистику](/openapi/promotion#tag/Statistika) кампаний продвижения и медиакампаний.   6. Работать с [календарём акций](/openapi/promotion#tag/Kalendar-akcij).  Данные синхронизируются с базой раз в 3 минуты. Статусы кампаний меняются раз в минуту. Ставки кампаний меняются раз в 30 секунд. 

    The version of the OpenAPI document: promotion
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from wildberries_sdk.promotion.models.request_with_campaign_id import RequestWithCampaignID
from wildberries_sdk.promotion.models.request_with_date import RequestWithDate
from wildberries_sdk.promotion.models.request_with_interval import RequestWithInterval
from pydantic import StrictStr, Field
from typing import Union, List, Set, Optional, Dict
from typing_extensions import Literal, Self

ADVV2FULLSTATSPOSTREQUESTINNER_ONE_OF_SCHEMAS = ["RequestWithCampaignID", "RequestWithDate", "RequestWithInterval"]

class AdvV2FullstatsPostRequestInner(BaseModel):
    """
    AdvV2FullstatsPostRequestInner
    """
    # data type: RequestWithDate
    oneof_schema_1_validator: Optional[RequestWithDate] = None
    # data type: RequestWithInterval
    oneof_schema_2_validator: Optional[RequestWithInterval] = None
    # data type: RequestWithCampaignID
    oneof_schema_3_validator: Optional[RequestWithCampaignID] = None
    actual_instance: Optional[Union[RequestWithCampaignID, RequestWithDate, RequestWithInterval]] = None
    one_of_schemas: Set[str] = { "RequestWithCampaignID", "RequestWithDate", "RequestWithInterval" }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = AdvV2FullstatsPostRequestInner.model_construct()
        error_messages = []
        match = 0
        # validate data type: RequestWithDate
        if not isinstance(v, RequestWithDate):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RequestWithDate`")
        else:
            match += 1
        # validate data type: RequestWithInterval
        if not isinstance(v, RequestWithInterval):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RequestWithInterval`")
        else:
            match += 1
        # validate data type: RequestWithCampaignID
        if not isinstance(v, RequestWithCampaignID):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RequestWithCampaignID`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in AdvV2FullstatsPostRequestInner with oneOf schemas: RequestWithCampaignID, RequestWithDate, RequestWithInterval. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in AdvV2FullstatsPostRequestInner with oneOf schemas: RequestWithCampaignID, RequestWithDate, RequestWithInterval. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # deserialize data into RequestWithDate
        try:
            instance.actual_instance = RequestWithDate.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into RequestWithInterval
        try:
            instance.actual_instance = RequestWithInterval.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into RequestWithCampaignID
        try:
            instance.actual_instance = RequestWithCampaignID.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into AdvV2FullstatsPostRequestInner with oneOf schemas: RequestWithCampaignID, RequestWithDate, RequestWithInterval. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into AdvV2FullstatsPostRequestInner with oneOf schemas: RequestWithCampaignID, RequestWithDate, RequestWithInterval. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], RequestWithCampaignID, RequestWithDate, RequestWithInterval]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


