# coding: utf-8

"""
    Маркетинг и продвижение

    <div class=\"description_important\">     Узнать больше о маркетинге и продвижении можно в <a href=\"https://seller.wildberries.ru/instructions/category/59d92bd3-6ea0-40f2-b762-ca8835d7d42e?goBackOption=prevRoute&categoryId=479385c6-de01-4b4d-ad4e-ed941e65582e\">справочном центре</a> </div>  Методы маркетинга и продвижения позволяют:   1. Получать информацию о кампаниях [продвижения](/openapi/promotion#tag/Kampanii) и [медиакампаниях](/openapi/promotion#tag/Media).   2. [Создавать](/openapi/promotion#tag/Sozdanie-kampanij) и [управлять](/openapi/promotion#tag/Upravlenie-kampaniyami) кампаниями.   3. Настраивать [параметры](/openapi/promotion#tag/Parametry-kampanij) кампаний — кластеры фраз, продвигаемые товары и так далее.   4. Управлять [финансами](/openapi/promotion#tag/Finansy) кампаний.   5. Выгружать [статистику](/openapi/promotion#tag/Statistika) кампаний продвижения и медиакампаний.   6. Работать с [календарём акций](/openapi/promotion#tag/Kalendar-akcij).  Данные синхронизируются с базой раз в 3 минуты. Статусы кампаний меняются раз в минуту. Ставки кампаний меняются раз в 30 секунд. 

    The version of the OpenAPI document: promotion
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from wildberries_sdk.promotion.models.api_v1_calendar_promotions_details_get200_response_data_promotions_inner_ranging_inner import ApiV1CalendarPromotionsDetailsGet200ResponseDataPromotionsInnerRangingInner
from typing import Optional, Set
from typing_extensions import Self

class ApiV1CalendarPromotionsDetailsGet200ResponseDataPromotionsInner(BaseModel):
    """
    ApiV1CalendarPromotionsDetailsGet200ResponseDataPromotionsInner
    """ # noqa: E501
    id: Optional[StrictInt] = Field(default=None, description="ID акции")
    name: Optional[StrictStr] = Field(default=None, description="Название акции")
    description: Optional[StrictStr] = Field(default=None, description="Описание акции")
    advantages: Optional[List[StrictStr]] = Field(default=None, description="Преимущества акции")
    start_date_time: Optional[StrictStr] = Field(default=None, description="Начало акции", alias="startDateTime")
    end_date_time: Optional[StrictStr] = Field(default=None, description="Конец акции", alias="endDateTime")
    in_promo_action_leftovers: Optional[StrictInt] = Field(default=None, description="Количество товаров с остатками, участвующих в акции", alias="inPromoActionLeftovers")
    in_promo_action_total: Optional[StrictInt] = Field(default=None, description="Общее количество товаров, участвующих в акции", alias="inPromoActionTotal")
    not_in_promo_action_leftovers: Optional[StrictInt] = Field(default=None, description="Количество товаров с остатками, не участвующих в акции", alias="notInPromoActionLeftovers")
    not_in_promo_action_total: Optional[StrictInt] = Field(default=None, description="Общее количество товаров, не участвующих в акции", alias="notInPromoActionTotal")
    participation_percentage: Optional[StrictInt] = Field(default=None, description="Уже участвующие в акции товары, %. Рассчитывается по товарам в акции и с остатком", alias="participationPercentage")
    type: Optional[StrictStr] = Field(default=None, description="Тип акции:   - `regular` — акция   - `auto` — автоакция ")
    exception_products_count: Optional[StrictInt] = Field(default=None, description="Количество товаров, исключенных из автоакции до её старта. Только при `\"type\": \"auto\"`. <br>В момент старта акции эти товары автоматически будут без скидки ", alias="exceptionProductsCount")
    ranging: Optional[List[ApiV1CalendarPromotionsDetailsGet200ResponseDataPromotionsInnerRangingInner]] = Field(default=None, description="Ранжирование (если подключено)")
    __properties: ClassVar[List[str]] = ["id", "name", "description", "advantages", "startDateTime", "endDateTime", "inPromoActionLeftovers", "inPromoActionTotal", "notInPromoActionLeftovers", "notInPromoActionTotal", "participationPercentage", "type", "exceptionProductsCount", "ranging"]

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['regular', 'auto']):
            raise ValueError("must be one of enum values ('regular', 'auto')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ApiV1CalendarPromotionsDetailsGet200ResponseDataPromotionsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in ranging (list)
        _items = []
        if self.ranging:
            for _item_ranging in self.ranging:
                if _item_ranging:
                    _items.append(_item_ranging.to_dict())
            _dict['ranging'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ApiV1CalendarPromotionsDetailsGet200ResponseDataPromotionsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "advantages": obj.get("advantages"),
            "startDateTime": obj.get("startDateTime"),
            "endDateTime": obj.get("endDateTime"),
            "inPromoActionLeftovers": obj.get("inPromoActionLeftovers"),
            "inPromoActionTotal": obj.get("inPromoActionTotal"),
            "notInPromoActionLeftovers": obj.get("notInPromoActionLeftovers"),
            "notInPromoActionTotal": obj.get("notInPromoActionTotal"),
            "participationPercentage": obj.get("participationPercentage"),
            "type": obj.get("type"),
            "exceptionProductsCount": obj.get("exceptionProductsCount"),
            "ranging": [ApiV1CalendarPromotionsDetailsGet200ResponseDataPromotionsInnerRangingInner.from_dict(_item) for _item in obj["ranging"]] if obj.get("ranging") is not None else None
        })
        return _obj


