# coding: utf-8

"""
    Маркетинг и продвижение

    <div class=\"description_important\">     Узнать больше о маркетинге и продвижении можно в <a href=\"https://seller.wildberries.ru/instructions/category/59d92bd3-6ea0-40f2-b762-ca8835d7d42e?goBackOption=prevRoute&categoryId=479385c6-de01-4b4d-ad4e-ed941e65582e\">справочном центре</a> </div>  Методы маркетинга и продвижения позволяют:   1. Получать информацию о кампаниях [продвижения](/openapi/promotion#tag/Kampanii) и [медиакампаниях](/openapi/promotion#tag/Media).   2. [Создавать](/openapi/promotion#tag/Sozdanie-kampanij) и [управлять](/openapi/promotion#tag/Upravlenie-kampaniyami) кампаниями.   3. Настраивать [параметры](/openapi/promotion#tag/Parametry-kampanij) кампаний — кластеры фраз, продвигаемые товары и так далее.   4. Управлять [финансами](/openapi/promotion#tag/Finansy) кампаний.   5. Выгружать [статистику](/openapi/promotion#tag/Statistika) кампаний продвижения и медиакампаний.   6. Работать с [календарём акций](/openapi/promotion#tag/Kalendar-akcij).  Данные синхронизируются с базой раз в 3 минуты. Статусы кампаний меняются раз в минуту. Ставки кампаний меняются раз в 30 секунд. 

    The version of the OpenAPI document: promotion
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from wildberries_sdk.promotion.models.days_inner_apps_inner_nm_inner import DaysInnerAppsInnerNmInner
from typing import Optional, Set
from typing_extensions import Self

class DaysInnerAppsInner(BaseModel):
    """
    DaysInnerAppsInner
    """ # noqa: E501
    views: Optional[StrictInt] = Field(default=None, description="Количество просмотров")
    clicks: Optional[StrictInt] = Field(default=None, description="Количество кликов")
    ctr: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Показатель кликабельности, отношение числа кликов к количеству показов, % ")
    cpc: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Средняя стоимость клика, ₽")
    sum: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Затраты, ₽")
    atbs: Optional[StrictInt] = Field(default=None, description="Количество добавлений товаров в корзину")
    orders: Optional[StrictInt] = Field(default=None, description="Количество заказов")
    cr: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="CR(conversion rate) — это отношение количества заказов к общему количеству посещений кампании ")
    shks: Optional[StrictInt] = Field(default=None, description="Количество заказанных товаров, шт.")
    sum_price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Заказов на сумму, ₽")
    nm: Optional[List[DaysInnerAppsInnerNmInner]] = Field(default=None, description="Блок статистики по артикулам WB")
    app_type: Optional[StrictInt] = Field(default=None, description="Тип платформы (`1` — сайт, `32` — Android, `64` — IOS)", alias="appType")
    __properties: ClassVar[List[str]] = ["views", "clicks", "ctr", "cpc", "sum", "atbs", "orders", "cr", "shks", "sum_price", "nm", "appType"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DaysInnerAppsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in nm (list)
        _items = []
        if self.nm:
            for _item_nm in self.nm:
                if _item_nm:
                    _items.append(_item_nm.to_dict())
            _dict['nm'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DaysInnerAppsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "views": obj.get("views"),
            "clicks": obj.get("clicks"),
            "ctr": obj.get("ctr"),
            "cpc": obj.get("cpc"),
            "sum": obj.get("sum"),
            "atbs": obj.get("atbs"),
            "orders": obj.get("orders"),
            "cr": obj.get("cr"),
            "shks": obj.get("shks"),
            "sum_price": obj.get("sum_price"),
            "nm": [DaysInnerAppsInnerNmInner.from_dict(_item) for _item in obj["nm"]] if obj.get("nm") is not None else None,
            "appType": obj.get("appType")
        })
        return _obj


