# coding: utf-8

"""
    Маркетинг и продвижение

    <div class=\"description_important\">     Узнать больше о маркетинге и продвижении можно в <a href=\"https://seller.wildberries.ru/instructions/category/59d92bd3-6ea0-40f2-b762-ca8835d7d42e?goBackOption=prevRoute&categoryId=479385c6-de01-4b4d-ad4e-ed941e65582e\">справочном центре</a> </div>  Методы маркетинга и продвижения позволяют:   1. Получать информацию о кампаниях [продвижения](/openapi/promotion#tag/Kampanii) и [медиакампаниях](/openapi/promotion#tag/Media).   2. [Создавать](/openapi/promotion#tag/Sozdanie-kampanij) и [управлять](/openapi/promotion#tag/Upravlenie-kampaniyami) кампаниями.   3. Настраивать [параметры](/openapi/promotion#tag/Parametry-kampanij) кампаний — кластеры фраз, продвигаемые товары и так далее.   4. Управлять [финансами](/openapi/promotion#tag/Finansy) кампаний.   5. Выгружать [статистику](/openapi/promotion#tag/Statistika) кампаний продвижения и медиакампаний.   6. Работать с [календарём акций](/openapi/promotion#tag/Kalendar-akcij).  Данные синхронизируются с базой раз в 3 минуты. Статусы кампаний меняются раз в минуту. Ставки кампаний меняются раз в 30 секунд. 

    The version of the OpenAPI document: promotion
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, field_validator
from typing import Any, ClassVar, Dict, List, Union
from wildberries_sdk.promotion.models.days_v3_inner_apps_inner_nms_inner import DaysV3InnerAppsInnerNmsInner
from typing import Optional, Set
from typing_extensions import Self

class DaysV3InnerAppsInner(BaseModel):
    """
    DaysV3InnerAppsInner
    """ # noqa: E501
    app_type: StrictInt = Field(description="Тип платформы:   - `1` — сайт   - `32` — Android   - `64` — IOS ", alias="appType")
    atbs: StrictInt = Field(description="Количество добавлений товаров в корзину")
    canceled: StrictInt = Field(description="Отмены, шт.")
    clicks: StrictInt = Field(description="Количество кликов")
    cpc: Union[StrictFloat, StrictInt] = Field(description="Средняя стоимость клика, ₽")
    cr: Union[StrictFloat, StrictInt] = Field(description="CR (conversion rate) — отношение количества заказов к общему количеству кликов")
    ctr: Union[StrictFloat, StrictInt] = Field(description="CTR (click-through rate) — отношение числа кликов к количеству показов в процентах")
    nms: List[DaysV3InnerAppsInnerNmsInner] = Field(description="Блок статистики по артикулам WB")
    orders: StrictInt = Field(description="Количество заказов")
    shks: StrictInt = Field(description="Количество заказанных товаров, шт.")
    sum: Union[StrictFloat, StrictInt] = Field(description="Затраты, ₽")
    sum_price: Union[StrictFloat, StrictInt] = Field(description="Заказов на сумму, ₽")
    views: StrictInt = Field(description="Количество просмотров")
    __properties: ClassVar[List[str]] = ["appType", "atbs", "canceled", "clicks", "cpc", "cr", "ctr", "nms", "orders", "shks", "sum", "sum_price", "views"]

    @field_validator('app_type')
    def app_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set([1, 32, 64]):
            raise ValueError("must be one of enum values (1, 32, 64)")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DaysV3InnerAppsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in nms (list)
        _items = []
        if self.nms:
            for _item_nms in self.nms:
                if _item_nms:
                    _items.append(_item_nms.to_dict())
            _dict['nms'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DaysV3InnerAppsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "appType": obj.get("appType"),
            "atbs": obj.get("atbs"),
            "canceled": obj.get("canceled"),
            "clicks": obj.get("clicks"),
            "cpc": obj.get("cpc"),
            "cr": obj.get("cr"),
            "ctr": obj.get("ctr"),
            "nms": [DaysV3InnerAppsInnerNmsInner.from_dict(_item) for _item in obj["nms"]] if obj.get("nms") is not None else None,
            "orders": obj.get("orders"),
            "shks": obj.get("shks"),
            "sum": obj.get("sum"),
            "sum_price": obj.get("sum_price"),
            "views": obj.get("views")
        })
        return _obj


