# coding: utf-8

"""
    Маркетинг и продвижение

    <div class=\"description_important\">     Узнать больше о маркетинге и продвижении можно в <a href=\"https://seller.wildberries.ru/instructions/category/59d92bd3-6ea0-40f2-b762-ca8835d7d42e?goBackOption=prevRoute&categoryId=479385c6-de01-4b4d-ad4e-ed941e65582e\">справочном центре</a> </div>  Методы маркетинга и продвижения позволяют:   1. Получать информацию о кампаниях [продвижения](/openapi/promotion#tag/Kampanii) и [медиакампаниях](/openapi/promotion#tag/Media).   2. [Создавать](/openapi/promotion#tag/Sozdanie-kampanij) и [управлять](/openapi/promotion#tag/Upravlenie-kampaniyami) кампаниями.   3. Настраивать [параметры](/openapi/promotion#tag/Parametry-kampanij) кампаний — кластеры фраз, продвигаемые товары и так далее.   4. Управлять [финансами](/openapi/promotion#tag/Finansy) кампаний.   5. Выгружать [статистику](/openapi/promotion#tag/Statistika) кампаний продвижения и медиакампаний.   6. Работать с [календарём акций](/openapi/promotion#tag/Kalendar-akcij).  Данные синхронизируются с базой раз в 3 минуты. Статусы кампаний меняются раз в минуту. Ставки кампаний меняются раз в 30 секунд. 

    The version of the OpenAPI document: promotion
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from wildberries_sdk.promotion.models.booster_stats_v3_inner import BoosterStatsV3Inner
from wildberries_sdk.promotion.models.days_v3_inner import DaysV3Inner
from typing import Optional, Set
from typing_extensions import Self

class FullStatsItem(BaseModel):
    """
    Статистика по одной кампании за период, указанный в запросе. По всем артикулам WB и платформам
    """ # noqa: E501
    advert_id: StrictInt = Field(description="ID кампании", alias="advertId")
    atbs: StrictInt = Field(description="Количество добавлений товаров в корзину")
    booster_stats: Optional[List[BoosterStatsV3Inner]] = Field(default=None, description="Статистика по средней позиции товара (для кампаний с единой ставкой)", alias="boosterStats")
    canceled: StrictInt = Field(description="Отмены, шт.")
    clicks: StrictInt = Field(description="Количество кликов")
    cpc: Union[StrictFloat, StrictInt] = Field(description="Средняя стоимость клика, ₽")
    cr: Union[StrictFloat, StrictInt] = Field(description="CR (conversion rate) — отношение количества заказов к общему количеству кликов")
    ctr: Union[StrictFloat, StrictInt] = Field(description="CTR (click-through rate) — отношение числа кликов к количеству показов в процентах")
    days: List[DaysV3Inner] = Field(description="Статистка по дням")
    orders: StrictInt = Field(description="Количество заказов")
    shks: StrictInt = Field(description="Количество заказанных товаров, шт.")
    sum: Union[StrictFloat, StrictInt] = Field(description="Затраты, ₽")
    sum_price: Union[StrictFloat, StrictInt] = Field(description="Сумма заказов, ₽")
    views: StrictInt = Field(description="Количество просмотров")
    __properties: ClassVar[List[str]] = ["advertId", "atbs", "boosterStats", "canceled", "clicks", "cpc", "cr", "ctr", "days", "orders", "shks", "sum", "sum_price", "views"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FullStatsItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in booster_stats (list)
        _items = []
        if self.booster_stats:
            for _item_booster_stats in self.booster_stats:
                if _item_booster_stats:
                    _items.append(_item_booster_stats.to_dict())
            _dict['boosterStats'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in days (list)
        _items = []
        if self.days:
            for _item_days in self.days:
                if _item_days:
                    _items.append(_item_days.to_dict())
            _dict['days'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FullStatsItem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "advertId": obj.get("advertId"),
            "atbs": obj.get("atbs"),
            "boosterStats": [BoosterStatsV3Inner.from_dict(_item) for _item in obj["boosterStats"]] if obj.get("boosterStats") is not None else None,
            "canceled": obj.get("canceled"),
            "clicks": obj.get("clicks"),
            "cpc": obj.get("cpc"),
            "cr": obj.get("cr"),
            "ctr": obj.get("ctr"),
            "days": [DaysV3Inner.from_dict(_item) for _item in obj["days"]] if obj.get("days") is not None else None,
            "orders": obj.get("orders"),
            "shks": obj.get("shks"),
            "sum": obj.get("sum"),
            "sum_price": obj.get("sum_price"),
            "views": obj.get("views")
        })
        return _obj


