# coding: utf-8

"""
    Маркетинг и продвижение

    <div class=\"description_important\">     Узнать больше о маркетинге и продвижении можно в <a href=\"https://seller.wildberries.ru/instructions/category/59d92bd3-6ea0-40f2-b762-ca8835d7d42e?goBackOption=prevRoute&categoryId=479385c6-de01-4b4d-ad4e-ed941e65582e\">справочном центре</a> </div>  Методы маркетинга и продвижения позволяют:   1. Получать информацию о кампаниях [продвижения](/openapi/promotion#tag/Kampanii) и [медиакампаниях](/openapi/promotion#tag/Media).   2. [Создавать](/openapi/promotion#tag/Sozdanie-kampanij) и [управлять](/openapi/promotion#tag/Upravlenie-kampaniyami) кампаниями.   3. Настраивать [параметры](/openapi/promotion#tag/Parametry-kampanij) кампаний — кластеры фраз, продвигаемые товары и так далее.   4. Управлять [финансами](/openapi/promotion#tag/Finansy) кампаний.   5. Выгружать [статистику](/openapi/promotion#tag/Statistika) кампаний продвижения и медиакампаний.   6. Работать с [календарём акций](/openapi/promotion#tag/Kalendar-akcij).  Данные синхронизируются с базой раз в 3 минуты. Статусы кампаний меняются раз в минуту. Ставки кампаний меняются раз в 30 секунд. 

    The version of the OpenAPI document: promotion
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List
from wildberries_sdk.promotion.models.advert_nms_settings import AdvertNMsSettings
from wildberries_sdk.promotion.models.advert_settings import AdvertSettings
from wildberries_sdk.promotion.models.timestamps import Timestamps
from typing import Optional, Set
from typing_extensions import Self

class GetAdvertsAdvertsInner(BaseModel):
    """
    GetAdvertsAdvertsInner
    """ # noqa: E501
    bid_type: StrictStr = Field(description="Тип ставки:   - `unified` — единая ставка   - `manual` — ручная ставка ")
    id: StrictInt = Field(description="ID кампании")
    nm_settings: List[AdvertNMsSettings] = Field(description="Настройки товаров")
    settings: AdvertSettings
    status: StrictInt = Field(description="Статус кампании: - `-1` — удалена, процесс удаления будет завершён в течение 10 минут - `4` — готова к запуску - `7` — завершена - `8` — отменена - `9` — активна - `11` — на паузе ")
    timestamps: Timestamps
    __properties: ClassVar[List[str]] = ["bid_type", "id", "nm_settings", "settings", "status", "timestamps"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set([-1, 4, 7, 8, 9, 11]):
            raise ValueError("must be one of enum values (-1, 4, 7, 8, 9, 11)")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetAdvertsAdvertsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in nm_settings (list)
        _items = []
        if self.nm_settings:
            for _item_nm_settings in self.nm_settings:
                if _item_nm_settings:
                    _items.append(_item_nm_settings.to_dict())
            _dict['nm_settings'] = _items
        # override the default output from pydantic by calling `to_dict()` of settings
        if self.settings:
            _dict['settings'] = self.settings.to_dict()
        # override the default output from pydantic by calling `to_dict()` of timestamps
        if self.timestamps:
            _dict['timestamps'] = self.timestamps.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetAdvertsAdvertsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "bid_type": obj.get("bid_type"),
            "id": obj.get("id"),
            "nm_settings": [AdvertNMsSettings.from_dict(_item) for _item in obj["nm_settings"]] if obj.get("nm_settings") is not None else None,
            "settings": AdvertSettings.from_dict(obj["settings"]) if obj.get("settings") is not None else None,
            "status": obj.get("status"),
            "timestamps": Timestamps.from_dict(obj["timestamps"]) if obj.get("timestamps") is not None else None
        })
        return _obj


