# coding: utf-8

"""
    Маркетинг и продвижение

    <div class=\"description_important\">     Узнать больше о маркетинге и продвижении можно в <a href=\"https://seller.wildberries.ru/instructions/category/59d92bd3-6ea0-40f2-b762-ca8835d7d42e?goBackOption=prevRoute&categoryId=479385c6-de01-4b4d-ad4e-ed941e65582e\">справочном центре</a> </div>  Методы маркетинга и продвижения позволяют:   1. Получать информацию о кампаниях [продвижения](/openapi/promotion#tag/Kampanii) и [медиакампаниях](/openapi/promotion#tag/Media).   2. [Создавать](/openapi/promotion#tag/Sozdanie-kampanij) и [управлять](/openapi/promotion#tag/Upravlenie-kampaniyami) кампаниями.   3. Настраивать [параметры](/openapi/promotion#tag/Parametry-kampanij) кампаний — кластеры фраз, продвигаемые товары и так далее.   4. Управлять [финансами](/openapi/promotion#tag/Finansy) кампаний.   5. Выгружать [статистику](/openapi/promotion#tag/Statistika) кампаний продвижения и медиакампаний.   6. Работать с [календарём акций](/openapi/promotion#tag/Kalendar-akcij).  Данные синхронизируются с базой раз в 3 минуты. Статусы кампаний меняются раз в минуту. Ставки кампаний меняются раз в 30 секунд. 

    The version of the OpenAPI document: promotion
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from wildberries_sdk.promotion.models.response_info_advert_type8_auto_params_active import ResponseInfoAdvertType8AutoParamsActive
from wildberries_sdk.promotion.models.response_info_advert_type8_auto_params_menus_inner import ResponseInfoAdvertType8AutoParamsMenusInner
from wildberries_sdk.promotion.models.response_info_advert_type8_auto_params_nm_cpm_inner import ResponseInfoAdvertType8AutoParamsNmCPMInner
from wildberries_sdk.promotion.models.response_info_advert_type8_auto_params_sets_inner import ResponseInfoAdvertType8AutoParamsSetsInner
from wildberries_sdk.promotion.models.response_info_advert_type8_auto_params_subject import ResponseInfoAdvertType8AutoParamsSubject
from typing import Optional, Set
from typing_extensions import Self

class ResponseInfoAdvertType8AutoParams(BaseModel):
    """
    ResponseInfoAdvertType8AutoParams
    """ # noqa: E501
    subject: Optional[ResponseInfoAdvertType8AutoParamsSubject] = None
    sets: Optional[List[ResponseInfoAdvertType8AutoParamsSetsInner]] = Field(default=None, description="Внутренняя (системная) сущность (пол + предмет)")
    menus: Optional[List[ResponseInfoAdvertType8AutoParamsMenusInner]] = None
    active: Optional[ResponseInfoAdvertType8AutoParamsActive] = None
    nm_cpm: Optional[List[ResponseInfoAdvertType8AutoParamsNmCPMInner]] = Field(default=None, description="Ставки карточек товаров ", alias="nmCPM")
    nms: Optional[List[StrictInt]] = Field(default=None, description="Артикулы WB")
    cpm: Optional[StrictInt] = Field(default=None, description="Ставка, указанная при создании кампании.<br> Поле актуально только для кампаний, созданных через API. ")
    __properties: ClassVar[List[str]] = ["subject", "sets", "menus", "active", "nmCPM", "nms", "cpm"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ResponseInfoAdvertType8AutoParams from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of subject
        if self.subject:
            _dict['subject'] = self.subject.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in sets (list)
        _items = []
        if self.sets:
            for _item_sets in self.sets:
                if _item_sets:
                    _items.append(_item_sets.to_dict())
            _dict['sets'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in menus (list)
        _items = []
        if self.menus:
            for _item_menus in self.menus:
                if _item_menus:
                    _items.append(_item_menus.to_dict())
            _dict['menus'] = _items
        # override the default output from pydantic by calling `to_dict()` of active
        if self.active:
            _dict['active'] = self.active.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in nm_cpm (list)
        _items = []
        if self.nm_cpm:
            for _item_nm_cpm in self.nm_cpm:
                if _item_nm_cpm:
                    _items.append(_item_nm_cpm.to_dict())
            _dict['nmCPM'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ResponseInfoAdvertType8AutoParams from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "subject": ResponseInfoAdvertType8AutoParamsSubject.from_dict(obj["subject"]) if obj.get("subject") is not None else None,
            "sets": [ResponseInfoAdvertType8AutoParamsSetsInner.from_dict(_item) for _item in obj["sets"]] if obj.get("sets") is not None else None,
            "menus": [ResponseInfoAdvertType8AutoParamsMenusInner.from_dict(_item) for _item in obj["menus"]] if obj.get("menus") is not None else None,
            "active": ResponseInfoAdvertType8AutoParamsActive.from_dict(obj["active"]) if obj.get("active") is not None else None,
            "nmCPM": [ResponseInfoAdvertType8AutoParamsNmCPMInner.from_dict(_item) for _item in obj["nmCPM"]] if obj.get("nmCPM") is not None else None,
            "nms": obj.get("nms"),
            "cpm": obj.get("cpm")
        })
        return _obj


