# coding: utf-8

"""
    Маркетинг и продвижение

    <div class=\"description_important\">     Узнать больше о маркетинге и продвижении можно в <a href=\"https://seller.wildberries.ru/instructions/category/59d92bd3-6ea0-40f2-b762-ca8835d7d42e?goBackOption=prevRoute&categoryId=479385c6-de01-4b4d-ad4e-ed941e65582e\">справочном центре</a> </div>  Методы маркетинга и продвижения позволяют:   1. Получать информацию о кампаниях [продвижения](/openapi/promotion#tag/Kampanii) и [медиакампаниях](/openapi/promotion#tag/Media).   2. [Создавать](/openapi/promotion#tag/Sozdanie-kampanij) и [управлять](/openapi/promotion#tag/Upravlenie-kampaniyami) кампаниями.   3. Настраивать [параметры](/openapi/promotion#tag/Parametry-kampanij) кампаний — кластеры фраз, продвигаемые товары и так далее.   4. Управлять [финансами](/openapi/promotion#tag/Finansy) кампаний.   5. Выгружать [статистику](/openapi/promotion#tag/Statistika) кампаний продвижения и медиакампаний.   6. Работать с [календарём акций](/openapi/promotion#tag/Kalendar-akcij).  Данные синхронизируются с базой раз в 3 минуты. Статусы кампаний меняются раз в минуту. Ставки кампаний меняются раз в 30 секунд. 

    The version of the OpenAPI document: promotion
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from wildberries_sdk.promotion.models.booster_stats_inner import BoosterStatsInner
from wildberries_sdk.promotion.models.days_inner import DaysInner
from wildberries_sdk.promotion.models.response_with_interval_inner_interval import ResponseWithIntervalInnerInterval
from typing import Optional, Set
from typing_extensions import Self

class ResponseWithIntervalInner(BaseModel):
    """
    ResponseWithIntervalInner
    """ # noqa: E501
    interval: Optional[ResponseWithIntervalInnerInterval] = None
    views: Optional[StrictInt] = Field(default=None, description="Количество просмотров. <br> За все дни запрошенного диапазона, по всем артикулам WB и платформам ")
    clicks: Optional[StrictInt] = Field(default=None, description="Количество кликов.<br> За все дни запрошенного диапазона, по всем артикулам WB и платформам ")
    ctr: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Показатель кликабельности.<br> Отношение числа кликов к количеству показов. Выражается в процентах.<br> За все дни запрошенного диапазона, по всем артикулам WB и платформам ")
    cpc: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Средняя стоимость клика, ₽.<br> За все дни запрошенного диапазона, по всем артикулам WB и платформам ")
    sum: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Затраты, ₽.<br> За все дни запрошенного диапазона, по всем артикулам WB и платформам ")
    atbs: Optional[StrictInt] = Field(default=None, description="Количество добавлений товаров в корзину.<br> За все дни запрошенного диапазона, по всем артикулам WB и платформам ")
    orders: Optional[StrictInt] = Field(default=None, description="Количество заказов.<br> За все дни запрошенного диапазона, по всем артикулам WB и платформам ")
    cr: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="CR(conversion rate) — это отношение количества заказов к общему количеству посещений кампании.<br> За все дни запрошенного диапазона, по всем артикулам WB и платформам ")
    shks: Optional[StrictInt] = Field(default=None, description="Количество заказанных товаров, шт.<br> За все дни запрошенного диапазона, по всем артикулам WB и платформам ")
    sum_price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Заказов на сумму, ₽<br> За все дни запрошенного диапазона, по всем артикулам WB и платформам ")
    days: Optional[List[DaysInner]] = Field(default=None, description="Статистка по дням")
    booster_stats: Optional[List[BoosterStatsInner]] = Field(default=None, description="Статистика по средней позиции товара на страницах поисковой выдачи и каталога (для кампаний с единой ставкой)", alias="boosterStats")
    advert_id: Optional[StrictInt] = Field(default=None, description="ID кампании", alias="advertId")
    __properties: ClassVar[List[str]] = ["interval", "views", "clicks", "ctr", "cpc", "sum", "atbs", "orders", "cr", "shks", "sum_price", "days", "boosterStats", "advertId"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ResponseWithIntervalInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of interval
        if self.interval:
            _dict['interval'] = self.interval.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in days (list)
        _items = []
        if self.days:
            for _item_days in self.days:
                if _item_days:
                    _items.append(_item_days.to_dict())
            _dict['days'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in booster_stats (list)
        _items = []
        if self.booster_stats:
            for _item_booster_stats in self.booster_stats:
                if _item_booster_stats:
                    _items.append(_item_booster_stats.to_dict())
            _dict['boosterStats'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ResponseWithIntervalInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "interval": ResponseWithIntervalInnerInterval.from_dict(obj["interval"]) if obj.get("interval") is not None else None,
            "views": obj.get("views"),
            "clicks": obj.get("clicks"),
            "ctr": obj.get("ctr"),
            "cpc": obj.get("cpc"),
            "sum": obj.get("sum"),
            "atbs": obj.get("atbs"),
            "orders": obj.get("orders"),
            "cr": obj.get("cr"),
            "shks": obj.get("shks"),
            "sum_price": obj.get("sum_price"),
            "days": [DaysInner.from_dict(_item) for _item in obj["days"]] if obj.get("days") is not None else None,
            "boosterStats": [BoosterStatsInner.from_dict(_item) for _item in obj["boosterStats"]] if obj.get("boosterStats") is not None else None,
            "advertId": obj.get("advertId")
        })
        return _obj


