# coding: utf-8

"""
    Маркетинг и продвижение

    <div class=\"description_important\">     Узнать больше о маркетинге и продвижении можно в <a href=\"https://seller.wildberries.ru/instructions/category/59d92bd3-6ea0-40f2-b762-ca8835d7d42e?goBackOption=prevRoute&categoryId=479385c6-de01-4b4d-ad4e-ed941e65582e\">справочном центре</a> </div>  Методы маркетинга и продвижения позволяют:   1. Получать информацию о кампаниях [продвижения](/openapi/promotion#tag/Kampanii) и [медиакампаниях](/openapi/promotion#tag/Media).   2. [Создавать](/openapi/promotion#tag/Sozdanie-kampanij) и [управлять](/openapi/promotion#tag/Upravlenie-kampaniyami) кампаниями.   3. Настраивать [параметры](/openapi/promotion#tag/Parametry-kampanij) кампаний — кластеры фраз, продвигаемые товары и так далее.   4. Управлять [финансами](/openapi/promotion#tag/Finansy) кампаний.   5. Выгружать [статистику](/openapi/promotion#tag/Statistika) кампаний продвижения и медиакампаний.   6. Работать с [календарём акций](/openapi/promotion#tag/Kalendar-akcij).  Данные синхронизируются с базой раз в 3 минуты. Статусы кампаний меняются раз в минуту. Ставки кампаний меняются раз в 30 секунд. 

    The version of the OpenAPI document: promotion
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from wildberries_sdk.promotion.models.daily_stats2_inner import DailyStats2Inner
from typing import Optional, Set
from typing_extensions import Self

class StatsBlok2(BaseModel):
    """
    StatsBlok2
    """ # noqa: E501
    item_id: Optional[StrictInt] = Field(default=None, description="ID баннера")
    item_name: Optional[StrictStr] = Field(default=None, description="Бренд")
    category_name: Optional[StrictStr] = Field(default=None, description="Название категории")
    advert_type: Optional[StrictInt] = Field(default=None, description="Тип медиакампании:   - `1` — размещение по дням   - `2` — размещение по просмотрам ")
    place: Optional[StrictInt] = Field(default=None, description="Место на странице")
    views: Optional[StrictInt] = Field(default=None, description="Количество просмотров")
    clicks: Optional[StrictInt] = Field(default=None, description="Количество кликов")
    cr: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="CR(conversion rate) — это отношение количества заказов к общему количеству посещений медиакампании ")
    ctr: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="CTR (click-through rate) — показатель кликабельности, отношение числа кликов к количеству показов в рамках медиакампании ")
    date_from: Optional[datetime] = Field(default=None, description="Время начала размещения")
    date_to: Optional[datetime] = Field(default=None, description="Время завершения размещения")
    subject_name: Optional[StrictStr] = Field(default=None, description="Родительская категория предмета")
    atbs: Optional[StrictInt] = Field(default=None, description="Количество добавлений товаров в корзину")
    orders: Optional[StrictInt] = Field(default=None, description="Количество заказов")
    price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Стоимость размещения")
    cpc: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="(cost per click) — цена клика по продвигаемому товару")
    status: Optional[StrictInt] = Field(default=None, description="Статус медиакампании")
    daily_stats: Optional[List[DailyStats2Inner]] = None
    expenses: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Стоимость размещения баннера")
    cr1: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Отношение количества добавлений в корзину к количеству кликов")
    cr2: Optional[StrictInt] = Field(default=None, description="Отношение количества заказов к количеству добавлений в корзину")
    __properties: ClassVar[List[str]] = ["item_id", "item_name", "category_name", "advert_type", "place", "views", "clicks", "cr", "ctr", "date_from", "date_to", "subject_name", "atbs", "orders", "price", "cpc", "status", "daily_stats", "expenses", "cr1", "cr2"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of StatsBlok2 from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in daily_stats (list)
        _items = []
        if self.daily_stats:
            for _item_daily_stats in self.daily_stats:
                if _item_daily_stats:
                    _items.append(_item_daily_stats.to_dict())
            _dict['daily_stats'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of StatsBlok2 from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "item_id": obj.get("item_id"),
            "item_name": obj.get("item_name"),
            "category_name": obj.get("category_name"),
            "advert_type": obj.get("advert_type"),
            "place": obj.get("place"),
            "views": obj.get("views"),
            "clicks": obj.get("clicks"),
            "cr": obj.get("cr"),
            "ctr": obj.get("ctr"),
            "date_from": obj.get("date_from"),
            "date_to": obj.get("date_to"),
            "subject_name": obj.get("subject_name"),
            "atbs": obj.get("atbs"),
            "orders": obj.get("orders"),
            "price": obj.get("price"),
            "cpc": obj.get("cpc"),
            "status": obj.get("status"),
            "daily_stats": [DailyStats2Inner.from_dict(_item) for _item in obj["daily_stats"]] if obj.get("daily_stats") is not None else None,
            "expenses": obj.get("expenses"),
            "cr1": obj.get("cr1"),
            "cr2": obj.get("cr2")
        })
        return _obj


